/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.AbstractObjectTest;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.list.LazyList;

public class LazyListTest
extends AbstractObjectTest {
    public LazyListTest(String testName) {
        super(testName);
    }

    @Override
    public Object makeObject() {
        Factory dateFactory = LocalDateTime::now;
        return new LazyList(new ArrayList(), dateFactory);
    }

    @Override
    public void testSimpleSerialization() {
    }

    @Override
    public void testSerializeDeserializeThenCompare() {
    }

    @Override
    public void testCanonicalEmptyCollectionExists() {
    }

    @Override
    public void testCanonicalFullCollectionExists() {
    }

    public void testElementCreationWithFactory() {
        Factory dateFactory = LocalDateTime::now;
        LazyList list = new LazyList(new ArrayList(), dateFactory);
        LazyListTest.assertTrue((boolean)list.isEmpty());
        LocalDateTime firstElement = (LocalDateTime)list.get(0);
        LazyListTest.assertNotNull((Object)firstElement);
        LazyListTest.assertFalse((boolean)list.isEmpty());
    }

    public void testElementCreationWithTransformer() {
        Factory dateFactory = LocalDateTime::now;
        LazyList list = new LazyList(new ArrayList(), dateFactory);
        LazyListTest.assertTrue((boolean)list.isEmpty());
        LocalDateTime firstElement = (LocalDateTime)list.get(0);
        LazyListTest.assertNotNull((Object)firstElement);
        LazyListTest.assertFalse((boolean)list.isEmpty());
    }

    public void testCreateNullGapsWithFactory() {
        Factory dateFactory = LocalDateTime::now;
        LazyList list = new LazyList(new ArrayList(), dateFactory);
        LocalDateTime fourthElement = (LocalDateTime)list.get(3);
        LazyListTest.assertFalse((boolean)list.isEmpty());
        LazyListTest.assertNotNull((Object)fourthElement);
    }

    public void testCreateNullGapsWithTransformer() {
        List<Integer> hours = Arrays.asList(7, 5, 8, 2);
        Transformer dateFactory = input -> LocalDateTime.now().withHour((Integer)hours.get((int)input));
        LazyList list = new LazyList(new ArrayList(), dateFactory);
        LocalDateTime fourthElement = (LocalDateTime)list.get(3);
        LazyListTest.assertFalse((boolean)list.isEmpty());
        LazyListTest.assertNotNull((Object)fourthElement);
    }
}

