/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.MultiBackgroundInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MultiBackgroundInitializerTest {
    private static final String CHILD_INIT = "childInitializer";
    private MultiBackgroundInitializer initializer;

    @BeforeEach
    public void setUp() {
        this.initializer = new MultiBackgroundInitializer();
    }

    private void checkChild(BackgroundInitializer<?> child, ExecutorService expExec) throws ConcurrentException {
        ChildBackgroundInitializer cinit = (ChildBackgroundInitializer)child;
        Integer result = (Integer)cinit.get();
        Assertions.assertEquals((int)1, (int)result, (String)"Wrong result");
        Assertions.assertEquals((int)1, (int)cinit.initializeCalls, (String)"Wrong number of executions");
        if (expExec != null) {
            Assertions.assertEquals((Object)expExec, (Object)cinit.currentExecutor, (String)"Wrong executor service");
        }
    }

    @Test
    public void testAddInitializerNullName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.initializer.addInitializer(null, (BackgroundInitializer)new ChildBackgroundInitializer()));
    }

    @Test
    public void testAddInitializerNullInit() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.initializer.addInitializer(CHILD_INIT, null));
    }

    @Test
    public void testInitializeNoChildren() throws ConcurrentException {
        Assertions.assertTrue((boolean)this.initializer.start(), (String)"Wrong result of start()");
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assertions.assertTrue((boolean)res.initializerNames().isEmpty(), (String)"Got child initializers");
        Assertions.assertTrue((boolean)this.initializer.getActiveExecutor().isShutdown(), (String)"Executor not shutdown");
    }

    private MultiBackgroundInitializer.MultiBackgroundInitializerResults checkInitialize() throws ConcurrentException {
        int count = 5;
        for (int i = 0; i < 5; ++i) {
            this.initializer.addInitializer(CHILD_INIT + i, (BackgroundInitializer)new ChildBackgroundInitializer());
        }
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assertions.assertEquals((int)5, (int)res.initializerNames().size(), (String)"Wrong number of child initializers");
        for (int i = 0; i < 5; ++i) {
            String key = CHILD_INIT + i;
            Assertions.assertTrue((boolean)res.initializerNames().contains(key), (String)("Name not found: " + key));
            Assertions.assertEquals((Object)1, (Object)res.getResultObject(key), (String)"Wrong result object");
            Assertions.assertFalse((boolean)res.isException(key), (String)"Exception flag");
            Assertions.assertNull((Object)((Object)res.getException(key)), (String)"Got an exception");
            this.checkChild(res.getInitializer(key), this.initializer.getActiveExecutor());
        }
        return res;
    }

    @Test
    public void testInitializeTempExec() throws ConcurrentException {
        this.checkInitialize();
        Assertions.assertTrue((boolean)this.initializer.getActiveExecutor().isShutdown(), (String)"Executor not shutdown");
    }

    @Test
    public void testInitializeExternalExec() throws ConcurrentException, InterruptedException {
        ExecutorService exec = Executors.newCachedThreadPool();
        try {
            this.initializer = new MultiBackgroundInitializer(exec);
            this.checkInitialize();
            Assertions.assertEquals((Object)exec, (Object)this.initializer.getActiveExecutor(), (String)"Wrong executor");
            Assertions.assertFalse((boolean)exec.isShutdown(), (String)"Executor was shutdown");
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitializeChildWithExecutor() throws ConcurrentException, InterruptedException {
        String initExec = "childInitializerWithExecutor";
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            ChildBackgroundInitializer c1 = new ChildBackgroundInitializer();
            ChildBackgroundInitializer c2 = new ChildBackgroundInitializer();
            c2.setExternalExecutor(exec);
            this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)c1);
            this.initializer.addInitializer("childInitializerWithExecutor", (BackgroundInitializer)c2);
            this.initializer.start();
            this.initializer.get();
            this.checkChild(c1, this.initializer.getActiveExecutor());
            this.checkChild(c2, exec);
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testAddInitializerAfterStart() throws ConcurrentException {
        this.initializer.start();
        Assertions.assertThrows(IllegalStateException.class, () -> this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)new ChildBackgroundInitializer()), (String)"Could add initializer after start()!");
        this.initializer.get();
    }

    @Test
    public void testResultGetInitializerUnknown() throws ConcurrentException {
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = this.checkInitialize();
        Assertions.assertThrows(NoSuchElementException.class, () -> res.getInitializer("unknown"));
    }

    @Test
    public void testResultGetResultObjectUnknown() throws ConcurrentException {
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = this.checkInitialize();
        Assertions.assertThrows(NoSuchElementException.class, () -> res.getResultObject("unknown"));
    }

    @Test
    public void testResultGetExceptionUnknown() throws ConcurrentException {
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = this.checkInitialize();
        Assertions.assertThrows(NoSuchElementException.class, () -> res.getException("unknown"));
    }

    @Test
    public void testResultIsExceptionUnknown() throws ConcurrentException {
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = this.checkInitialize();
        Assertions.assertThrows(NoSuchElementException.class, () -> res.isException("unknown"));
    }

    @Test
    public void testResultInitializerNamesModify() throws ConcurrentException {
        this.checkInitialize();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Iterator it = res.initializerNames().iterator();
        it.next();
        Assertions.assertThrows(UnsupportedOperationException.class, it::remove);
    }

    @Test
    public void testInitializeRuntimeEx() {
        ChildBackgroundInitializer child = new ChildBackgroundInitializer();
        child.ex = new RuntimeException();
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)child);
        this.initializer.start();
        Exception ex = (Exception)Assertions.assertThrows(Exception.class, () -> ((MultiBackgroundInitializer)this.initializer).get());
        Assertions.assertEquals((Object)child.ex, (Object)ex, (String)"Wrong exception");
    }

    @Test
    public void testInitializeEx() throws ConcurrentException {
        ChildBackgroundInitializer child = new ChildBackgroundInitializer();
        child.ex = new Exception();
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)child);
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assertions.assertTrue((boolean)res.isException(CHILD_INIT), (String)"No exception flag");
        Assertions.assertNull((Object)res.getResultObject(CHILD_INIT), (String)"Got a results object");
        ConcurrentException cex = res.getException(CHILD_INIT);
        Assertions.assertEquals((Object)child.ex, (Object)cex.getCause(), (String)"Wrong cause");
    }

    @Test
    public void testInitializeResultsIsSuccessfulTrue() throws ConcurrentException {
        ChildBackgroundInitializer child = new ChildBackgroundInitializer();
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)child);
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assertions.assertTrue((boolean)res.isSuccessful(), (String)"Wrong success flag");
    }

    @Test
    public void testInitializeResultsIsSuccessfulFalse() throws ConcurrentException {
        ChildBackgroundInitializer child = new ChildBackgroundInitializer();
        child.ex = new Exception();
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)child);
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assertions.assertFalse((boolean)res.isSuccessful(), (String)"Wrong success flag");
    }

    @Test
    public void testInitializeNested() throws ConcurrentException {
        String nameMulti = "multiChildInitializer";
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)new ChildBackgroundInitializer());
        MultiBackgroundInitializer mi2 = new MultiBackgroundInitializer();
        int count = 3;
        for (int i = 0; i < 3; ++i) {
            mi2.addInitializer(CHILD_INIT + i, (BackgroundInitializer)new ChildBackgroundInitializer());
        }
        this.initializer.addInitializer("multiChildInitializer", (BackgroundInitializer)mi2);
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        ExecutorService exec = this.initializer.getActiveExecutor();
        this.checkChild(res.getInitializer(CHILD_INIT), exec);
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res2 = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)res.getResultObject("multiChildInitializer");
        Assertions.assertEquals((int)3, (int)res2.initializerNames().size(), (String)"Wrong number of initializers");
        for (int i = 0; i < 3; ++i) {
            this.checkChild(res2.getInitializer(CHILD_INIT + i), exec);
        }
        Assertions.assertTrue((boolean)exec.isShutdown(), (String)"Executor not shutdown");
    }

    private static class ChildBackgroundInitializer
    extends BackgroundInitializer<Integer> {
        volatile ExecutorService currentExecutor;
        volatile int initializeCalls;
        Exception ex;

        private ChildBackgroundInitializer() {
        }

        protected Integer initialize() throws Exception {
            this.currentExecutor = this.getActiveExecutor();
            ++this.initializeCalls;
            if (this.ex != null) {
                throw this.ex;
            }
            return this.initializeCalls;
        }
    }
}

