/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MutableObjectTest {
    @Test
    public void testConstructors() {
        Assertions.assertNull((Object)new MutableObject().getValue());
        Integer i = 6;
        Assertions.assertSame((Object)i, (Object)new MutableObject((Object)i).getValue());
        Assertions.assertSame((Object)"HI", (Object)new MutableObject((Object)"HI").getValue());
        Assertions.assertSame(null, (Object)new MutableObject(null).getValue());
    }

    @Test
    public void testGetSet() {
        MutableObject mutNum = new MutableObject();
        Assertions.assertNull((Object)new MutableObject().getValue());
        mutNum.setValue((Object)"HELLO");
        Assertions.assertSame((Object)"HELLO", (Object)mutNum.getValue());
        mutNum.setValue(null);
        Assertions.assertSame(null, (Object)mutNum.getValue());
    }

    @Test
    public void testEquals() {
        MutableObject mutNumA = new MutableObject((Object)"ALPHA");
        MutableObject mutNumB = new MutableObject((Object)"ALPHA");
        MutableObject mutNumC = new MutableObject((Object)"BETA");
        MutableObject mutNumD = new MutableObject(null);
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumB);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumB);
        Assertions.assertNotEquals((Object)mutNumA, (Object)mutNumC);
        Assertions.assertNotEquals((Object)mutNumB, (Object)mutNumC);
        Assertions.assertEquals((Object)mutNumC, (Object)mutNumC);
        Assertions.assertNotEquals((Object)mutNumA, (Object)mutNumD);
        Assertions.assertEquals((Object)mutNumD, (Object)mutNumD);
        Assertions.assertNotEquals(null, (Object)mutNumA);
        Assertions.assertNotEquals((Object)mutNumA, (Object)new Object());
        Assertions.assertNotEquals((Object)"0", (Object)mutNumA);
    }

    @Test
    public void testHashCode() {
        MutableObject mutNumA = new MutableObject((Object)"ALPHA");
        MutableObject mutNumB = new MutableObject((Object)"ALPHA");
        MutableObject mutNumC = new MutableObject((Object)"BETA");
        MutableObject mutNumD = new MutableObject(null);
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumA.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumB.hashCode());
        Assertions.assertNotEquals((int)mutNumA.hashCode(), (int)mutNumC.hashCode());
        Assertions.assertNotEquals((int)mutNumA.hashCode(), (int)mutNumD.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)"ALPHA".hashCode());
        Assertions.assertEquals((int)0, (int)mutNumD.hashCode());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"HI", (Object)new MutableObject((Object)"HI").toString());
        Assertions.assertEquals((Object)"10.0", (Object)new MutableObject((Object)10.0).toString());
        Assertions.assertEquals((Object)"null", (Object)new MutableObject(null).toString());
    }
}

