/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;

public class CaptureException
extends AssignmentOperation {
    private Throwable exception;

    public CaptureException(Throwable t) {
        this.exception = t;
    }

    public void evaluate(IRuntimeSession mySession) {
        String value;
        IVariable variable = mySession.getVariable("ddLastException");
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "Capturing exception [" + this.exception.getClass().getName() + "].  Message [" + this.exception.getLocalizedMessage() + "]");
        }
        StringWriter sw = new StringWriter(1024);
        this.exception.printStackTrace(new PrintWriter((Writer)sw, true));
        String stackTrace = sw.toString();
        if (variable == null) {
            mySession.getTraceOutput().writeln(4, "No session variable \"ddLastException\" found in session. Unable to capture exception data.");
            mySession.getTraceOutput().writeln(4, stackTrace);
            return;
        }
        IComplexVariable cplx = variable.getComplexVariable();
        IVariableField field = cplx.getField("object");
        if (field != null) {
            field.setValue((Object)this.exception);
        }
        if ((field = cplx.getField("type")) != null) {
            field.setValue(this.exception.getClass().getName());
        }
        if ((field = cplx.getField("message")) != null) {
            field.setValue(this.exception.getLocalizedMessage());
        }
        if ((field = cplx.getField("stacktrace")) != null) {
            field.setValue(stackTrace);
        }
        if ((field = cplx.getField("errorcode")) != null) {
            int errorCode = 0;
            if (this.exception instanceof SQLException) {
                errorCode = ((SQLException)this.exception).getErrorCode();
            }
            field.setValue(errorCode);
        }
        if ((value = mySession.getParameter("showcaughtexceptions")) != null && value.equalsIgnoreCase("enabled")) {
            mySession.getTraceOutput().writeln(4, stackTrace);
        }
    }
}

