/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.ISQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerDriverBooleanProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverIntProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class SQLServerDataSource
implements ISQLServerDataSource,
DataSource,
Serializable,
Referenceable {
    static final Logger dsLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerDataSource");
    static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.DataSource");
    private final String loggingClassName;
    private boolean trustStorePasswordStripped = false;
    private static final long serialVersionUID = 654861379544314296L;
    private Properties connectionProps = new Properties();
    private String dataSourceURL;
    private String dataSourceDescription;
    private static int baseDataSourceID = 0;
    private final String traceID;
    private transient PrintWriter logWriter;

    public SQLServerDataSource() {
        int n = SQLServerDataSource.nextDataSourceID();
        String string = this.getClass().getName();
        this.traceID = string.substring(1 + string.lastIndexOf(46)) + ":" + n;
        this.loggingClassName = "com.microsoft.sqlserver.jdbc." + string.substring(1 + string.lastIndexOf(46)) + ":" + n;
    }

    String getClassNameLogging() {
        return this.loggingClassName;
    }

    public String toString() {
        return this.traceID;
    }

    @Override
    public Connection getConnection() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getConnection");
        SQLServerConnection sQLServerConnection = this.getConnectionInternal(null, null, null);
        loggerExternal.exiting(this.getClassNameLogging(), "getConnection", sQLServerConnection);
        return sQLServerConnection;
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getConnection", new Object[]{string, "Password not traced"});
        }
        SQLServerConnection sQLServerConnection = this.getConnectionInternal(string, string2, null);
        loggerExternal.exiting(this.getClassNameLogging(), "getConnection", sQLServerConnection);
        return sQLServerConnection;
    }

    @Override
    public void setLoginTimeout(int n) {
        this.setIntProperty(this.connectionProps, SQLServerDriverIntProperty.LOGIN_TIMEOUT.toString(), n);
    }

    @Override
    public int getLoginTimeout() {
        int n = SQLServerDriverIntProperty.LOGIN_TIMEOUT.getDefaultValue();
        int n2 = this.getIntProperty(this.connectionProps, SQLServerDriverIntProperty.LOGIN_TIMEOUT.toString(), n);
        return n2 == 0 ? n : n2;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        loggerExternal.entering(this.getClassNameLogging(), "setLogWriter", printWriter);
        this.logWriter = printWriter;
        loggerExternal.exiting(this.getClassNameLogging(), "setLogWriter");
    }

    @Override
    public PrintWriter getLogWriter() {
        loggerExternal.entering(this.getClassNameLogging(), "getLogWriter");
        loggerExternal.exiting(this.getClassNameLogging(), "getLogWriter", this.logWriter);
        return this.logWriter;
    }

    @Override
    public void setApplicationName(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.APPLICATION_NAME.toString(), string);
    }

    @Override
    public String getApplicationName() {
        return this.getStringProperty(this.connectionProps, SQLServerDriverStringProperty.APPLICATION_NAME.toString(), SQLServerDriverStringProperty.APPLICATION_NAME.getDefaultValue());
    }

    @Override
    public void setDatabaseName(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.DATABASE_NAME.toString(), string);
    }

    @Override
    public String getDatabaseName() {
        return this.getStringProperty(this.connectionProps, SQLServerDriverStringProperty.DATABASE_NAME.toString(), null);
    }

    @Override
    public void setInstanceName(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.INSTANCE_NAME.toString(), string);
    }

    @Override
    public String getInstanceName() {
        return this.getStringProperty(this.connectionProps, SQLServerDriverStringProperty.INSTANCE_NAME.toString(), null);
    }

    @Override
    public void setIntegratedSecurity(boolean bl) {
        this.setBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.INTEGRATED_SECURITY.toString(), bl);
    }

    @Override
    public void setAuthenticationScheme(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.AUTHENTICATION_SCHEME.toString(), string);
    }

    @Override
    public void setLastUpdateCount(boolean bl) {
        this.setBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.LAST_UPDATE_COUNT.toString(), bl);
    }

    @Override
    public boolean getLastUpdateCount() {
        return this.getBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.LAST_UPDATE_COUNT.toString(), SQLServerDriverBooleanProperty.LAST_UPDATE_COUNT.getDefaultValue());
    }

    @Override
    public void setEncrypt(boolean bl) {
        this.setBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.ENCRYPT.toString(), bl);
    }

    @Override
    public boolean getEncrypt() {
        return this.getBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.ENCRYPT.toString(), SQLServerDriverBooleanProperty.ENCRYPT.getDefaultValue());
    }

    @Override
    public void setTrustServerCertificate(boolean bl) {
        this.setBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.TRUST_SERVER_CERTIFICATE.toString(), bl);
    }

    @Override
    public boolean getTrustServerCertificate() {
        return this.getBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.TRUST_SERVER_CERTIFICATE.toString(), SQLServerDriverBooleanProperty.TRUST_SERVER_CERTIFICATE.getDefaultValue());
    }

    @Override
    public void setTrustStore(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.TRUST_STORE.toString(), string);
    }

    @Override
    public String getTrustStore() {
        return this.getStringProperty(this.connectionProps, SQLServerDriverStringProperty.TRUST_STORE.toString(), null);
    }

    @Override
    public void setTrustStorePassword(String string) {
        if (string != null) {
            this.trustStorePasswordStripped = false;
        }
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.TRUST_STORE_PASSWORD.toString(), string);
    }

    @Override
    public void setHostNameInCertificate(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.HOSTNAME_IN_CERTIFICATE.toString(), string);
    }

    @Override
    public String getHostNameInCertificate() {
        return this.getStringProperty(this.connectionProps, SQLServerDriverStringProperty.HOSTNAME_IN_CERTIFICATE.toString(), null);
    }

    @Override
    public void setLockTimeout(int n) {
        this.setIntProperty(this.connectionProps, SQLServerDriverIntProperty.LOCK_TIMEOUT.toString(), n);
    }

    @Override
    public int getLockTimeout() {
        return this.getIntProperty(this.connectionProps, SQLServerDriverIntProperty.LOCK_TIMEOUT.toString(), SQLServerDriverIntProperty.LOCK_TIMEOUT.getDefaultValue());
    }

    @Override
    public void setPassword(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.PASSWORD.toString(), string);
    }

    String getPassword() {
        return this.getStringProperty(this.connectionProps, SQLServerDriverStringProperty.PASSWORD.toString(), null);
    }

    @Override
    public void setPortNumber(int n) {
        this.setIntProperty(this.connectionProps, SQLServerDriverIntProperty.PORT_NUMBER.toString(), n);
    }

    @Override
    public int getPortNumber() {
        return this.getIntProperty(this.connectionProps, SQLServerDriverIntProperty.PORT_NUMBER.toString(), SQLServerDriverIntProperty.PORT_NUMBER.getDefaultValue());
    }

    @Override
    public void setSelectMethod(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.SELECT_METHOD.toString(), string);
    }

    @Override
    public String getSelectMethod() {
        return this.getStringProperty(this.connectionProps, SQLServerDriverStringProperty.SELECT_METHOD.toString(), SQLServerDriverStringProperty.SELECT_METHOD.getDefaultValue());
    }

    @Override
    public void setResponseBuffering(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.RESPONSE_BUFFERING.toString(), string);
    }

    @Override
    public String getResponseBuffering() {
        return this.getStringProperty(this.connectionProps, SQLServerDriverStringProperty.RESPONSE_BUFFERING.toString(), SQLServerDriverStringProperty.RESPONSE_BUFFERING.getDefaultValue());
    }

    @Override
    public void setApplicationIntent(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.APPLICATION_INTENT.toString(), string);
    }

    @Override
    public String getApplicationIntent() {
        return this.getStringProperty(this.connectionProps, SQLServerDriverStringProperty.APPLICATION_INTENT.toString(), SQLServerDriverStringProperty.APPLICATION_INTENT.getDefaultValue());
    }

    @Override
    public void setSendTimeAsDatetime(boolean bl) {
        this.setBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.SEND_TIME_AS_DATETIME.toString(), bl);
    }

    @Override
    public boolean getSendTimeAsDatetime() {
        return this.getBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.SEND_TIME_AS_DATETIME.toString(), SQLServerDriverBooleanProperty.SEND_TIME_AS_DATETIME.getDefaultValue());
    }

    @Override
    public void setSendStringParametersAsUnicode(boolean bl) {
        this.setBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.SEND_STRING_PARAMETERS_AS_UNICODE.toString(), bl);
    }

    @Override
    public boolean getSendStringParametersAsUnicode() {
        return this.getBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.SEND_STRING_PARAMETERS_AS_UNICODE.toString(), SQLServerDriverBooleanProperty.SEND_STRING_PARAMETERS_AS_UNICODE.getDefaultValue());
    }

    @Override
    public void setServerName(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.SERVER_NAME.toString(), string);
    }

    @Override
    public String getServerName() {
        return this.getStringProperty(this.connectionProps, SQLServerDriverStringProperty.SERVER_NAME.toString(), null);
    }

    @Override
    public void setFailoverPartner(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.FAILOVER_PARTNER.toString(), string);
    }

    @Override
    public String getFailoverPartner() {
        return this.getStringProperty(this.connectionProps, SQLServerDriverStringProperty.FAILOVER_PARTNER.toString(), null);
    }

    @Override
    public void setMultiSubnetFailover(boolean bl) {
        this.setBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.MULTI_SUBNET_FAILOVER.toString(), bl);
    }

    @Override
    public boolean getMultiSubnetFailover() {
        return this.getBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.MULTI_SUBNET_FAILOVER.toString(), SQLServerDriverBooleanProperty.MULTI_SUBNET_FAILOVER.getDefaultValue());
    }

    @Override
    public void setUser(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.USER.toString(), string);
    }

    @Override
    public String getUser() {
        return this.getStringProperty(this.connectionProps, SQLServerDriverStringProperty.USER.toString(), null);
    }

    @Override
    public void setWorkstationID(String string) {
        this.setStringProperty(this.connectionProps, SQLServerDriverStringProperty.WORKSTATION_ID.toString(), string);
    }

    @Override
    public String getWorkstationID() {
        String string;
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getWorkstationID");
        }
        if (null == (string = this.connectionProps.getProperty(SQLServerDriverStringProperty.WORKSTATION_ID.toString()))) {
            string = Util.lookupHostName();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getWorkstationID", string);
        return string;
    }

    @Override
    public void setXopenStates(boolean bl) {
        this.setBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.XOPEN_STATES.toString(), bl);
    }

    @Override
    public boolean getXopenStates() {
        return this.getBooleanProperty(this.connectionProps, SQLServerDriverBooleanProperty.XOPEN_STATES.toString(), SQLServerDriverBooleanProperty.XOPEN_STATES.getDefaultValue());
    }

    @Override
    public void setURL(String string) {
        loggerExternal.entering(this.getClassNameLogging(), "setURL", string);
        this.dataSourceURL = string;
        loggerExternal.exiting(this.getClassNameLogging(), "setURL");
    }

    @Override
    public String getURL() {
        String string = this.dataSourceURL;
        loggerExternal.entering(this.getClassNameLogging(), "getURL");
        if (null == this.dataSourceURL) {
            string = "jdbc:sqlserver://";
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getURL", string);
        return string;
    }

    @Override
    public void setDescription(String string) {
        loggerExternal.entering(this.getClassNameLogging(), "setDescription", string);
        this.dataSourceDescription = string;
        loggerExternal.exiting(this.getClassNameLogging(), "setDescription");
    }

    @Override
    public String getDescription() {
        loggerExternal.entering(this.getClassNameLogging(), "getDescription");
        loggerExternal.exiting(this.getClassNameLogging(), "getDescription", this.dataSourceDescription);
        return this.dataSourceDescription;
    }

    @Override
    public void setPacketSize(int n) {
        this.setIntProperty(this.connectionProps, SQLServerDriverIntProperty.PACKET_SIZE.toString(), n);
    }

    @Override
    public int getPacketSize() {
        return this.getIntProperty(this.connectionProps, SQLServerDriverIntProperty.PACKET_SIZE.toString(), SQLServerDriverIntProperty.PACKET_SIZE.getDefaultValue());
    }

    private void setStringProperty(Properties properties, String string, String string2) {
        if (loggerExternal.isLoggable(Level.FINER) && !string.contains("password") && !string.contains("Password")) {
            loggerExternal.entering(this.getClassNameLogging(), "set" + string, string2);
        } else {
            loggerExternal.entering(this.getClassNameLogging(), "set" + string);
        }
        if (null != string2) {
            properties.setProperty(string, string2);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "set" + string);
    }

    private String getStringProperty(Properties properties, String string, String string2) {
        String string3;
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "get" + string);
        }
        if (null == (string3 = properties.getProperty(string))) {
            string3 = string2;
        }
        if (loggerExternal.isLoggable(Level.FINER) && !string.contains("password") && !string.contains("Password")) {
            loggerExternal.exiting(this.getClassNameLogging(), "get" + string, string3);
        }
        return string3;
    }

    private void setIntProperty(Properties properties, String string, int n) {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "set" + string, new Integer(n));
        }
        properties.setProperty(string, new Integer(n).toString());
        loggerExternal.exiting(this.getClassNameLogging(), "set" + string);
    }

    private int getIntProperty(Properties properties, String string, int n) {
        int n2;
        block5: {
            if (loggerExternal.isLoggable(Level.FINER)) {
                loggerExternal.entering(this.getClassNameLogging(), "get" + string);
            }
            String string2 = properties.getProperty(string);
            n2 = n;
            if (null != string2) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)("Bad portNumber:-" + string2));
                }
            }
        }
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "get" + string, new Integer(n2));
        }
        return n2;
    }

    private void setBooleanProperty(Properties properties, String string, boolean bl) {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "set" + string, bl);
        }
        properties.setProperty(string, bl ? "true" : "false");
        loggerExternal.exiting(this.getClassNameLogging(), "set" + string);
    }

    private boolean getBooleanProperty(Properties properties, String string, boolean bl) {
        String string2;
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "get" + string);
        }
        Boolean bl2 = null == (string2 = properties.getProperty(string)) ? Boolean.valueOf(bl) : Boolean.valueOf(string2);
        loggerExternal.exiting(this.getClassNameLogging(), "get" + string, bl2);
        return bl2;
    }

    SQLServerConnection getConnectionInternal(String string, String string2, SQLServerPooledConnection sQLServerPooledConnection) throws SQLServerException {
        Object object;
        Properties properties = null;
        Properties properties2 = null;
        if (this.trustStorePasswordStripped) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_referencingFailedTSP"), null, true);
        }
        if (null != string || null != string2) {
            properties = (Properties)this.connectionProps.clone();
            properties.remove(SQLServerDriverStringProperty.USER.toString());
            properties.remove(SQLServerDriverStringProperty.PASSWORD.toString());
            if (null != string) {
                properties.put(SQLServerDriverStringProperty.USER.toString(), string);
            }
            if (null != string2) {
                properties.put(SQLServerDriverStringProperty.PASSWORD.toString(), string2);
            }
        } else {
            properties = this.connectionProps;
        }
        if (null != this.dataSourceURL) {
            object = Util.parseUrl(this.dataSourceURL, dsLogger);
            if (null == object) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
            }
            properties2 = SQLServerDriver.mergeURLAndSuppliedProperties((Properties)object, properties);
        } else {
            properties2 = properties;
        }
        if (dsLogger.isLoggable(Level.FINER)) {
            dsLogger.finer(this.toString() + " Begin create new connection.");
        }
        object = new SQLServerConnection(this.toString());
        ((SQLServerConnection)object).connect(properties2, sQLServerPooledConnection);
        if (dsLogger.isLoggable(Level.FINER)) {
            dsLogger.finer(this.toString() + " End create new connection " + ((SQLServerConnection)object).toString());
        }
        return object;
    }

    @Override
    public Reference getReference() {
        loggerExternal.entering(this.getClassNameLogging(), "getReference");
        Reference reference = this.getReferenceInternal("com.microsoft.sqlserver.jdbc.SQLServerDataSource");
        loggerExternal.exiting(this.getClassNameLogging(), "getReference", reference);
        return reference;
    }

    Reference getReferenceInternal(String string) {
        if (dsLogger.isLoggable(Level.FINER)) {
            dsLogger.finer(this.toString() + " creating reference for " + string + ".");
        }
        Reference reference = new Reference(this.getClass().getName(), "com.microsoft.sqlserver.jdbc.SQLServerDataSourceObjectFactory", null);
        if (null != string) {
            reference.add(new StringRefAddr("class", string));
        }
        if (this.trustStorePasswordStripped) {
            reference.add(new StringRefAddr("trustStorePasswordStripped", "true"));
        }
        Enumeration<Object> enumeration = this.connectionProps.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals(SQLServerDriverStringProperty.TRUST_STORE_PASSWORD.toString())) {
                assert (!this.trustStorePasswordStripped);
                reference.add(new StringRefAddr("trustStorePasswordStripped", "true"));
                continue;
            }
            if (string2.contains(SQLServerDriverStringProperty.PASSWORD.toString())) continue;
            reference.add(new StringRefAddr(string2, this.connectionProps.getProperty(string2)));
        }
        if (null != this.dataSourceURL) {
            reference.add(new StringRefAddr("dataSourceURL", this.dataSourceURL));
        }
        if (null != this.dataSourceDescription) {
            reference.add(new StringRefAddr("dataSourceDescription", this.dataSourceDescription));
        }
        return reference;
    }

    void initializeFromReference(Reference reference) {
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            StringRefAddr stringRefAddr = (StringRefAddr)enumeration.nextElement();
            String string = stringRefAddr.getType();
            String string2 = (String)stringRefAddr.getContent();
            if (string.equals("dataSourceURL")) {
                this.dataSourceURL = string2;
                continue;
            }
            if (string.equals("dataSourceDescription")) {
                this.dataSourceDescription = string2;
                continue;
            }
            if (string.equals("trustStorePasswordStripped")) {
                this.trustStorePasswordStripped = true;
                continue;
            }
            if (string.equals("class")) continue;
            this.connectionProps.setProperty(string, string2);
        }
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "isWrapperFor", clazz);
        DriverJDBCVersion.checkSupportsJDBC4();
        boolean bl = clazz.isInstance(this);
        loggerExternal.exiting(this.getClassNameLogging(), "isWrapperFor", bl);
        return bl;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t;
        loggerExternal.entering(this.getClassNameLogging(), "unwrap", clazz);
        DriverJDBCVersion.checkSupportsJDBC4();
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new SQLServerException(classCastException.getMessage(), classCastException);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "unwrap", t);
        return t;
    }

    private static synchronized int nextDataSourceID() {
        return ++baseDataSourceID;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("");
    }

    private static class SerializationProxy
    implements Serializable {
        private final Reference ref;
        private static final long serialVersionUID = 654661379542314226L;

        SerializationProxy(SQLServerDataSource sQLServerDataSource) {
            this.ref = sQLServerDataSource.getReferenceInternal(null);
        }

        private Object readResolve() {
            SQLServerDataSource sQLServerDataSource = new SQLServerDataSource();
            sQLServerDataSource.initializeFromReference(this.ref);
            return sQLServerDataSource;
        }
    }
}

