/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti.ir;

import com.avaya.sce.runtime.connectivity.cti.CallInfoData;
import com.avaya.sce.runtime.connectivity.cti.VariableUtil;
import com.avaya.sce.runtime.connectivity.cti.ir.CTICommand;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class ConsultationCall
extends CTICommand {
    private String addressToCall;
    private String uui;
    private String ringMax;
    private boolean transferOnRing;
    private boolean uuiAsAscii;
    private VariableName varName = null;
    private Object addressObject = null;
    private VariableName holdCallData = null;
    private Object uuiObject = null;
    private Object ringMaxObject = null;

    public ConsultationCall(String name, SCESession session, Object heldCallAddress, Object addr, Object uui, boolean uuiAsAscii, Object ringMax, boolean transferOnRing) {
        super(session);
        this.varName = new VariableName(name);
        this.addressObject = addr;
        this.holdCallData = (VariableName)heldCallAddress;
        this.uuiObject = uui;
        this.ringMaxObject = ringMax;
        if (uui != null) {
            this.setUUIAsAscii(uuiAsAscii);
            this.uuiObject = uui;
        }
        this.setTransferOnRing(transferOnRing);
    }

    public void processResponse(String rawResponse) {
        int dx;
        CallInfoData cid = this.processCallInfoResults(rawResponse);
        if (cid != null) {
            LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)"CallInfo.doGetCallInfo: Populating held call info variable values...");
            this.setCallInfoVariableValues(this.holdCallData.toString(), cid);
        }
        if ((dx = rawResponse.indexOf("callid", 5)) != -1 && (cid = this.processCallInfoResults(rawResponse.substring(dx))) != null) {
            LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)"CallInfo.doGetCallInfo: Populating dialed call info variable values...");
            this.setCallInfoVariableValues(this.varName.toString(), cid);
        }
    }

    public void preExecute() {
        if (this.addressObject instanceof VariableName) {
            this.setDestinationAddress(VariableUtil.getVariableValue((IRuntimeSession)this.session, (VariableName)this.addressObject));
        } else if (this.addressObject instanceof String) {
            this.setDestinationAddress((String)this.addressObject);
        } else {
            throw new IllegalArgumentException("Illegal address type " + this.addressObject.getClass().getName());
        }
        if (this.uuiObject != null) {
            if (this.uuiObject instanceof VariableName) {
                this.setUUI(VariableUtil.getVariableValue((IRuntimeSession)this.session, (VariableName)this.uuiObject));
            } else if (this.uuiObject instanceof String) {
                this.setUUI(this.uui);
            } else {
                throw new IllegalArgumentException("Illegal uui type " + this.uuiObject.getClass().getName());
            }
        }
        if (this.ringMaxObject != null) {
            if (this.ringMaxObject instanceof VariableName) {
                this.setRingMax(VariableUtil.getVariableValue((IRuntimeSession)this.session, (VariableName)this.ringMaxObject));
            } else if (this.ringMaxObject instanceof Integer) {
                this.setRingMax(String.valueOf(this.ringMaxObject));
            } else {
                throw new IllegalArgumentException("Illegal ring max type " + this.ringMaxObject.getClass().getName());
            }
        }
    }

    public String getServletNameParams() {
        String uui = this.getUUI() == null ? "null" : this.getUUI();
        try {
            if (this.isIR()) {
                return "/aesconnector/ConsultationCall?" + URLEncoder.encode("callee=" + this.getDestinationAddress() + "&uui=" + uui + "&uuiAsAscii=" + this.getUUIAsAscii() + "&holdAddress=" + this.getHoldCallId() + "&ringMax=" + this.getRingMax() + "&channel=" + this.getExtensionFromSession() + "&transferOnRing=" + this.getTransferOnRing(), "UTF-8");
            }
            return "/aesconnector/ConsultationCall?" + URLEncoder.encode("callee=" + this.getDestinationAddress() + "&uui=" + uui + "&uuiAsAscii=" + this.getUUIAsAscii() + "&holdAddress=" + this.getHoldCallId() + "&ringMax=" + this.getRingMax() + "&extension=" + this.getExtensionFromSession() + "&transferOnRing=" + this.getTransferOnRing(), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public void setDestinationAddress(String addr) {
        this.addressToCall = addr.trim();
    }

    public String getDestinationAddress() {
        return this.addressToCall;
    }

    protected String getHoldCallId() {
        VariableName vName = new VariableName(this.holdCallData.toString(), "callid");
        String callId = VariableUtil.getVariableValue((IRuntimeSession)this.getSession(), vName);
        if (callId != null && callId.length() > 0) {
            return callId;
        }
        this.session.throwRTException("No valid call id in CTI Transfer operation for held variable");
        return null;
    }

    public void setUUI(String uui) {
        this.uui = uui.trim().length() > 0 ? uui : "null";
    }

    public String getUUI() {
        return this.uui;
    }

    private void setRingMax(String ringMax) {
        this.ringMax = ringMax;
    }

    private String getRingMax() {
        return this.ringMax;
    }

    private void setTransferOnRing(boolean transferOnRing) {
        this.transferOnRing = transferOnRing;
    }

    private boolean getTransferOnRing() {
        return this.transferOnRing;
    }

    private void setUUIAsAscii(boolean uuiAsAscii) {
        this.uuiAsAscii = uuiAsAscii;
    }

    private boolean getUUIAsAscii() {
        return this.uuiAsAscii;
    }
}

