/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti.pdc;

import com.avaya.sce.runtime.IPluggableConnectorLifeCycle;
import com.avaya.sce.runtime.SimpleVariable;
import com.avaya.sce.runtime.connectivity.cti.CTIOpFactory;
import com.avaya.sce.runtime.varoperations.CaptureException;
import com.avaya.sce.runtimecommon.IExecutable;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;

public class CTIConnectorInit
implements IPluggableConnectorLifeCycle {
    private static final boolean DEBUG_SANITY_CHECKS = true;

    public void applicationStarted(IRuntimeSession session, boolean isMainApplication) {
    }

    public void initialVariablesPosted(IRuntimeSession session, boolean isMainApplication) {
        if (!isMainApplication) {
            return;
        }
        SCESession mySession = (SCESession)session;
        if (mySession.getStackSize() > 1) {
            throw new IllegalStateException("AES Connector init was called in a module.");
        }
        IVariable cti = mySession.getVariable("cticallinfo");
        if (cti == null) {
            throw new IllegalStateException("AES connector init was called but project variables do not exist!");
        }
        IVariableField channel = mySession.getVariableField("session", "channel");
        IVariableField callInfoRetrieved = mySession.getVariableField("NewCTICallInfoRetrieved");
        if (channel != null && callInfoRetrieved == null && channel.getStringValue().length() != 0) {
            IVariable ccr = SimpleVariable.createSimpleVariable((String)"NewCTICallInfoRetrieved", (boolean)false, null, (SCESession)mySession, (boolean)false, (boolean)false);
            mySession.putVariable(ccr);
            try {
                String ctiAutoInvoke = mySession.getParameter("sage.cti.autoinvoke.callinfo");
                if (ctiAutoInvoke == null || ctiAutoInvoke.equalsIgnoreCase("true")) {
                    IExecutable callInfoExe = CTIOpFactory.createCallInfoInitialCallOperation(mySession);
                    callInfoExe.execute();
                }
            }
            catch (SCERuntimeException e) {
                CaptureException ce = new CaptureException((Throwable)e);
                ce.evaluate((IRuntimeSession)mySession);
                throw e;
            }
            finally {
                ccr.getSimpleVariable().setValue(true);
            }
        }
    }

    public void sentApplicationExit(IRuntimeSession session) {
        SCESession mySession = (SCESession)session;
        IVariable cti = mySession.getVariable("cticallinfo");
        if (cti == null) {
            throw new IllegalStateException("AES connector sentApplicationExit was called but cticallinfo variable does not exist!");
        }
        IVariableField channel = mySession.getVariableField("session", "channel");
        IVariableField callInfoRetrieved = mySession.getVariableField("NewCTICallInfoRetrieved");
        if (channel != null && callInfoRetrieved != null) {
            IVariableField callid = mySession.getVariableField("cticallinfo", "callid");
            String cid = "";
            if (callid != null) {
                cid = callid.getStringValue();
            }
            IExecutable ctiEnd = CTIOpFactory.createCTIEndOperation(mySession, channel.getStringValue(), cid);
            ctiEnd.execute();
        }
    }

    public void applicationReentered(IRuntimeSession session) {
        IVariable cti = session.getVariable("cticallinfo");
        if (cti != null && session.isTraceEnabled()) {
            IVariableField channel = session.getVariableField("session", "channel");
            session.getTraceOutput().writeln(3, "AES connector has already issued CTI End command, but application has been re-entered.  channel: " + channel.getStringValue());
        }
    }
}

