/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtimecommon.ICollection;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.VariableName;
import java.util.StringTokenizer;

public class Parse
extends AssignmentOperation {
    String destName;
    String sourceName;
    String separatorChar;
    boolean includeEmptyStrings;

    public Parse(String destName, String sourceName, String separatorChar, boolean includeEmptyStrings) {
        this.destName = destName;
        this.sourceName = sourceName;
        this.separatorChar = separatorChar;
        this.includeEmptyStrings = includeEmptyStrings;
    }

    public void evaluate(IRuntimeSession mySession) {
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "Parsing [" + this.sourceName + "] to [" + this.destName + "] with separatorChar [" + this.separatorChar + "]");
        }
        StringTokenizer strTok = new StringTokenizer(this.getStringValue(mySession, new VariableName(this.sourceName)), this.separatorChar, true);
        IVariable destVar = mySession.getVariable(this.destName);
        if (!destVar.isCollection()) {
            destVar.addCollection();
        }
        ICollection collection = destVar.getCollection();
        IVariableField field = destVar.getSimpleVariable();
        collection.removeAll();
        boolean lastWasSeparatorChar = false;
        while (strTok.hasMoreElements()) {
            String value = strTok.nextToken();
            if (this.separatorChar.indexOf(value) == -1) {
                field.setValue(value);
                collection.append();
                lastWasSeparatorChar = false;
                continue;
            }
            if (lastWasSeparatorChar && this.includeEmptyStrings) {
                field.setValue("");
                collection.append();
            }
            lastWasSeparatorChar = true;
        }
        collection.reset();
        if (collection.size() > 0) {
            collection.next();
        }
    }
}

