/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti.ir;

import com.avaya.ade.common.utils.crypto.Crypto;
import com.avaya.sce.runtime.connectivity.cti.CallInfoData;
import com.avaya.sce.runtime.connectivity.cti.ICTICommand;
import com.avaya.sce.runtime.connectivity.cti.VariableUtil;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IExecutable;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;

public abstract class CTICommand
extends Debugging
implements IExecutable,
ICTICommand {
    static final String ERROR = "error";
    SCESession session;

    CTICommand(SCESession session) {
        this.session = session;
    }

    SCESession getSession() {
        return this.session;
    }

    protected boolean canThrowException() {
        return true;
    }

    public void preExecute() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        String protocol;
        String host;
        int port;
        this.preExecute();
        URL srcURL = null;
        String sResponse = null;
        String rawResponse = null;
        try {
            srcURL = new URL(this.getSession().getRequestCopyURL().toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        String localPort = this.session.getParameter("sage.cti.localport");
        if (localPort != null && localPort.length() > 0) {
            port = Integer.valueOf(localPort);
            host = "localhost";
            protocol = srcURL.getProtocol();
        } else {
            port = srcURL.getPort() != -1 ? srcURL.getPort() : srcURL.getDefaultPort();
            host = srcURL.getHost();
            protocol = srcURL.getProtocol();
        }
        String key = host + "|" + System.currentTimeMillis();
        String pwd = "";
        try {
            pwd = new String(Crypto.encrypt((byte[])key.getBytes()));
            LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICommand.execute: encrypted value  is " + pwd));
        }
        catch (Exception e) {
            // empty catch block
        }
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            String reqURL = port != -1 ? protocol + "://" + host + ":" + port + this.getServletNameParams() + "&k=" + URLEncoder.encode(pwd, "UTF-8") : protocol + "://" + host + this.getServletNameParams() + "&k=" + URLEncoder.encode(pwd, "UTF-8");
            LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICommand.execute: request to manager is " + reqURL));
            URL urlRequestID = new URL(reqURL);
            URLConnection urlConnection = urlRequestID.openConnection();
            urlConnection.addRequestProperty("Cookie", "___DDSESSIONID=" + this.getSession().getSessionId());
            LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICommand.execute:  setting session cookie to " + this.getSession().getSessionId()));
            urlConnection.connect();
            inputStream = urlConnection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            rawResponse = reader.readLine();
            sResponse = URLDecoder.decode(rawResponse, "UTF-8");
            LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICommand.execute: callinfo from Manager is " + sResponse));
            if (sResponse.startsWith(ERROR) && this.canThrowException()) {
                this.session.throwRTException(sResponse.substring(6));
            }
        }
        catch (Exception e) {
            if (this.canThrowException()) {
                this.session.throwRTException("Error Executing CTI Command", e);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {}
        }
        this.processResponse(rawResponse);
    }

    protected boolean isIR() {
        return this.session.getPlatformSettings().getPlatform().equals("IR");
    }

    protected String getExtensionFromSession() {
        return VariableUtil.getSessionVariable((IRuntimeSession)this.getSession(), "channel").getStringValue();
    }

    protected CallInfoData processCallInfoResults(String rawResponse) {
        LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICommand.processCallInfoResults: rawResponse: " + rawResponse));
        try {
            String[] results = rawResponse.split("&");
            String callID = URLDecoder.decode(results[0].split("=")[1], "UTF-8");
            String callingNumber = URLDecoder.decode(results[1].split("=")[1], "UTF-8");
            String calledNumber = URLDecoder.decode(results[2].split("=")[1], "UTF-8");
            String extension = URLDecoder.decode(results[3].split("=")[1], "UTF-8");
            String ucId = URLDecoder.decode(results[4].split("=")[1], "UTF-8");
            String uui = URLDecoder.decode(results[5].split("=")[1], "UTF-8");
            String state = URLDecoder.decode(results[6].split("=")[1], "UTF-8");
            return new CallInfoData(callID, callingNumber, calledNumber, extension, ucId, uui, state);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void updateCallInfoVariableState(VariableName varName, String state) {
        if (state.length() == 0) {
            return;
        }
        IComplexVariable infoVar = (IComplexVariable)this.getSession().getVariable(varName.toString());
        infoVar.getField("state").setValue(state);
        LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICommand.setCallInfoVariableValues: State " + state));
    }

    protected void setCallInfoVariableValues(String varName, CallInfoData info) {
        if (info == null) {
            return;
        }
        IComplexVariable infoVar = (IComplexVariable)this.getSession().getVariable(varName);
        infoVar.getField("callid").setValue(info.getCallId());
        LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICommand.setCallInfoVariableValues: Call ID " + info.getCallId()));
        infoVar.getField("ani").setValue(info.getCallingNumber());
        LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICommand.setCallInfoVariableValues: Calling # (ANI) " + info.getCallingNumber()));
        infoVar.getField("dnis").setValue(info.getCalledNumber());
        LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICommand.setCallInfoVariableValues: Called # (DNIS) " + info.getCalledNumber()));
        infoVar.getField("stationextension").setValue(info.getExtension());
        LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICommand.setCallInfoVariableValues: Ext " + info.getExtension()));
        infoVar.getField("ucid").setValue(info.getUCID());
        LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICommand.setCallInfoVariableValues: UCID " + info.getUCID()));
        infoVar.getField("uui").setValue(info.getUUI());
        LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICommand.setCallInfoVariableValues: UUI " + info.getUUI()));
        infoVar.getField("state").setValue(info.getState());
        LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICommand.setCallInfoVariableValues: State " + info.getState()));
    }
}

