package com.avaya.sce.pdc.pe.launchobcall;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

import com.avaya.sce.runtimecommon.IPerformanceTracker;
import com.avaya.sce.runtimecommon.IReportInfo;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.ITraceInfo;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.VariableName;

/*
 * This allows a stand alone testing of the runtime implementation.
 */
public class RuntimeSessionAdapter implements IRuntimeSession {
	HashMap<String, IVariableField> variables = new HashMap<String, IVariableField>();

	public String getCurrentLocationId() {
		return null;
	}

	public String getParameter(String arg0) {
		return null;
	}

	public IPerformanceTracker getPerformanceTracker() {
		return null;
	}

	public String getSessionId() {
		return ("RuntimeSessionAdapter-1");
	}

	private ITraceInfo trace = new ITraceInfo() {
		public void writeln(int level, String value) {
			System.out.println("TRACE : " + level + " - " + value);
		}

		public void close() {
		}

	};

	public ITraceInfo getTraceOutput() {
		return (trace);
	}

	public IVariable getVariable(String arg0) {
		return null;
	}

	public IVariableField getVariableField(String varName, String fieldName) {
		VariableName name = new VariableName(varName, fieldName);
		return (getVariableField(name));
	}

	public IVariableField getVariableField(VariableName name) {
		IVariableField f = variables.get(name.toString());
		if (f == null) {
			f = new VariableAdapter();
			variables.put(name.toString(), f);
		}
		return (f);
	}

	public boolean isTraceEnabled() {
		return true;
	}

	public void setupProxy() {
		Properties props = System.getProperties();
		props.put("http" + ".proxyHost", "co.proxy.avaya.com");
		props.put("http" + ".proxyPort", "8000");
		System.setProperties(props);
	}

	public void throwRTException(String message, Exception e) {
		System.out.println("RUNTIME EXCEPTION - " + message + " " + e.toString());
		e.printStackTrace();

	}

	public void throwRTException(String message) {
		System.out.println("RUNTIME EXCEPTION - " + message);
	}

	public File createTempFile(String arg0) throws IOException {
		return null;
	}

	public String getProjectDirectory() {
		return null;
	}

	public IReportInfo getReportOutput() {
		return null;
	}

}
