/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti;

import com.avaya.ade.common.utils.crypto.Crypto;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import java.util.StringTokenizer;

public class CTIResource {
    public static final String CTI_NS = "dd.cti";
    public static final String CTI_NAMES = "dd.cti.names";
    public static final String DELIMITER = "|";
    private String name;
    private String host;
    private String serviceName;
    private String user;
    private String passwd;

    private static String decrypt(String value) throws SCERuntimeException {
        try {
            String result = new String(Crypto.decrypt((byte[])value.getBytes()));
            return result;
        }
        catch (Exception e) {
            throw new SCERuntimeException("De-cryption Error on TServer password", e);
        }
    }

    private String getNext(StringTokenizer str) {
        if (str.hasMoreElements()) {
            String item = str.nextToken();
            return item;
        }
        return "";
    }

    public CTIResource(String data) throws SCERuntimeException {
        StringTokenizer str = new StringTokenizer(data, DELIMITER);
        this.name = this.getNext(str);
        this.host = this.getNext(str);
        this.serviceName = this.getNext(str);
        this.user = this.getNext(str);
        this.passwd = CTIResource.decrypt(this.getNext(str));
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getUser() {
        return this.user;
    }

    public String getPasswd() {
        return this.passwd;
    }
}

