/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti.desktop;

import com.avaya.sce.runtime.connectivity.cti.CallInfoData;
import com.avaya.sce.runtime.connectivity.cti.VariableUtil;
import com.avaya.sce.runtime.connectivity.cti.desktop.CTICallOperation;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;

public class ConferenceParty
extends CTICallOperation {
    private String partyNumber;

    public ConferenceParty(SCESession session, Object conferenceCallData, Object partyNumber) {
        super(session);
        if (conferenceCallData == null) {
            return;
        }
        if (!(conferenceCallData instanceof VariableName)) {
            throw new IllegalArgumentException("Illegal call id type " + conferenceCallData.getClass().getName());
        }
        VariableName vName = new VariableName(conferenceCallData.toString(), "callid");
        conferenceCallData = VariableUtil.getVariableValue((IRuntimeSession)session, vName);
        if (partyNumber instanceof VariableName) {
            String number = VariableUtil.getVariableValue((IRuntimeSession)session, (VariableName)partyNumber);
            this.setPartyNumber(number.trim());
        } else if (partyNumber instanceof String) {
            this.setPartyNumber(((String)partyNumber).trim());
        } else {
            throw new IllegalArgumentException("Illegal partynumber type " + partyNumber.getClass().getName());
        }
    }

    protected void handleResponse(String msg) {
        CallInfoData data = this.getCurrentCallInfo();
        data.setState(msg);
    }

    public void doOperation() {
        this.sendMessage("conferenceparty:" + this.getPartyNumber());
        this.receiveMessage();
    }

    public String getPartyNumber() {
        return this.partyNumber;
    }

    public void setPartyNumber(String partyNumber) {
        this.partyNumber = partyNumber;
    }
}

