/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti.ir;

import com.avaya.sce.runtime.connectivity.cti.CallInfoData;
import com.avaya.sce.runtime.connectivity.cti.VariableUtil;
import com.avaya.sce.runtime.connectivity.cti.ir.CTICommand;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class Transfer
extends CTICommand {
    private VariableName heldCallData;
    private VariableName activeCallData;

    public Transfer(SCESession session, Object heldCallData, Object activeCallData) {
        super(session);
        this.heldCallData = (VariableName)heldCallData;
        this.activeCallData = (VariableName)activeCallData;
    }

    public void processResponse(String rawResponse) {
        CallInfoData cid = this.processCallInfoResults(rawResponse);
        if (cid != null) {
            this.updateCallInfoVariableState(this.heldCallData, cid.getState());
        }
    }

    public String getServletNameParams() {
        try {
            if (this.isIR()) {
                return "/aesconnector/Transfer?" + URLEncoder.encode("heldcallid=" + this.getHeldCallId() + "&activeCallId=" + this.getActiveCallId(), "UTF-8") + URLEncoder.encode("&channel=" + this.getExtensionFromSession(), "UTF-8");
            }
            return "/aesconnector/Transfer?" + URLEncoder.encode("heldcallid=" + this.getHeldCallId() + "&activeCallId=" + this.getActiveCallId(), "UTF-8") + URLEncoder.encode("&extension=" + this.getExtensionFromSession(), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    protected String getHeldCallId() {
        VariableName vName = new VariableName(this.heldCallData.toString(), "callid");
        String callId = VariableUtil.getVariableValue((IRuntimeSession)this.getSession(), vName);
        if (callId != null && callId.length() > 0) {
            return callId;
        }
        this.session.throwRTException("No valid call id in CTI Transfer operation for held variable");
        return null;
    }

    protected String getActiveCallId() {
        VariableName vName = new VariableName(this.activeCallData.toString(), "callid");
        String callId = VariableUtil.getVariableValue((IRuntimeSession)this.getSession(), vName);
        if (callId != null && callId.length() > 0) {
            return callId;
        }
        this.session.throwRTException("No valid call id in CTI Transfer operation for held variable");
        return null;
    }
}

