/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtimecommon.SCERuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DataFetcher
extends HttpServlet {
    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.requestHandler(request, response);
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.requestHandler(request, response);
    }

    private final void requestHandler(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File f;
        String uri = request.getRequestURI();
        int index = uri.indexOf("data");
        if (index == -1) {
            SCERuntimeException ex = new SCERuntimeException("Invalid data request URI");
            throw ex;
        }
        uri = uri.substring(index);
        ServletConfig cfg = this.getServletConfig();
        ServletContext ctx = cfg.getServletContext();
        String path = ctx.getRealPath(uri);
        long value = request.getDateHeader("if-modified-since");
        if (value != -1L && (f = new File(path)).lastModified() <= value) {
            response.sendError(304);
            return;
        }
        if (request.getRequestURI().endsWith(".wav") || request.getRequestURI().endsWith(".ulaw")) {
            response.setHeader("Content-Type", "audio/x-wav");
        }
        if (request.getRequestURI().endsWith(".au")) {
            response.setHeader("Content-Type", "audio/x-au");
        }
        f = new File(path);
        response.setDateHeader("Last-Modified", f.lastModified());
        response.setHeader("Content-Length", Long.toString(f.length()));
        FileInputStream iStream = null;
        ServletOutputStream oStream = null;
        try {
            iStream = new FileInputStream(path);
            oStream = response.getOutputStream();
            int bytesRead = 0;
            byte[] buffer = new byte[131072];
            do {
                if ((bytesRead = ((InputStream)iStream).read(buffer, 0, buffer.length)) == -1) continue;
                oStream.write(buffer, 0, bytesRead);
            } while (bytesRead != -1);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (iStream != null) {
                try {
                    ((InputStream)iStream).close();
                }
                catch (Exception e2) {}
            }
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (Exception e2) {}
            }
        }
        Enumeration e = request.getHeaders("Cache-Control");
        while (e.hasMoreElements()) {
            String val = (String)e.nextElement();
            if (response.containsHeader("Cache-Control")) {
                response.addHeader("Cache-Control", val);
                continue;
            }
            response.setHeader("Cache-Control", val);
        }
    }
}

