/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.internal;

import com.avaya.sce.runtime.Email;
import com.avaya.sce.runtime.internal.ItemFinder;
import com.avaya.sce.runtime.internal.ResourceFinder;
import com.avaya.sce.runtimecommon.SCERuntimeException;

public class AttachmentFinder
extends ResourceFinder {
    public static final String TYPE = "ATTACHMENT";

    public static AttachmentFinder getAttachmentFinder(String language) {
        return (AttachmentFinder)ItemFinder.getFinder(TYPE, language);
    }

    public static Email.EmailAttachment load(String name, String language) {
        Email.EmailAttachment attachment = null;
        if (name != null) {
            try {
                attachment = (Email.EmailAttachment)AttachmentFinder.getAttachmentFinder(language).getInstance(name);
            }
            catch (Exception e) {
                throw new SCERuntimeException("Error instantiating attachment", e);
            }
        }
        return attachment;
    }

    public AttachmentFinder(String appLanguage) {
        super(appLanguage);
    }

    public String resolveResourceName(String simpleName) {
        StringBuilder itemName = new StringBuilder(100);
        itemName.append("/data");
        itemName.append("/");
        itemName.append(this.appLanguage);
        itemName.append("/");
        itemName.append("email");
        itemName.append("/");
        itemName.append(simpleName);
        return itemName.toString();
    }

    protected String resolveName(String simpleName) {
        StringBuilder className = new StringBuilder(100);
        className.append(this.appLanguage);
        className.append(".");
        className.append("email");
        className.append(".");
        className.append(simpleName);
        return className.toString();
    }
}

