/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti.ir;

import com.avaya.sce.runtime.connectivity.cti.CallInfoData;
import com.avaya.sce.runtime.connectivity.cti.VariableUtil;
import com.avaya.sce.runtime.connectivity.cti.ir.CTICommand;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class BlindCall
extends CTICommand {
    private String addressToCall;
    private String uui;
    private boolean uuiAsAscii;
    private VariableName varName = null;
    private Object addressObject = null;
    private VariableName holdCallData = null;
    private Object uuiObject = null;

    public BlindCall(String name, SCESession session, Object holdCallAddress, Object addr, Object uui, boolean uuiAsAscii) {
        super(session);
        this.varName = new VariableName(name);
        this.addressObject = addr;
        this.holdCallData = (VariableName)holdCallAddress;
        this.uuiObject = uui;
        if (uui != null) {
            this.setUUIAsAscii(uuiAsAscii);
            this.uuiObject = uui;
        }
    }

    public void processResponse(String rawResponse) {
        CallInfoData cid;
        if (!rawResponse.equalsIgnoreCase("error") && (cid = this.processCallInfoResults(rawResponse)) != null) {
            LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)"CallInfo.doGetCallInfo: Populating call info variable values...");
            this.setCallInfoVariableValues(this.varName.toString(), cid);
        }
    }

    public void preExecute() {
        if (this.addressObject instanceof VariableName) {
            this.setDestinationAddress(VariableUtil.getVariableValue((IRuntimeSession)this.session, (VariableName)this.addressObject));
        } else if (this.addressObject instanceof String) {
            this.setDestinationAddress((String)this.addressObject);
        } else {
            throw new IllegalArgumentException("Illegal address type " + this.addressObject.getClass().getName());
        }
        if (this.uuiObject != null) {
            if (this.uuiObject instanceof VariableName) {
                this.setUUI(VariableUtil.getVariableValue((IRuntimeSession)this.session, (VariableName)this.uuiObject));
            } else if (this.uuiObject instanceof String) {
                this.setUUI((String)this.uuiObject);
            } else {
                throw new IllegalArgumentException("Illegal uui type " + this.uuiObject.getClass().getName());
            }
        }
    }

    public String getServletNameParams() {
        String uui = this.getUUI() == null ? "null" : this.getUUI();
        try {
            if (this.isIR()) {
                return "/aesconnector/BlindCall?" + URLEncoder.encode("callee=" + this.getDestinationAddress() + "&uui=" + uui + "&uuiAsAscii=" + this.getUUIAsAscii() + "&holdAddress=" + this.getHoldCallId() + "&channel=" + this.getExtensionFromSession(), "UTF-8");
            }
            return "/aesconnector/BlindCall?" + URLEncoder.encode("callee=" + this.getDestinationAddress() + "&uui=" + uui + "&uuiAsAscii=" + this.getUUIAsAscii() + "&holdAddress=" + this.getHoldCallId() + "&extension=" + this.getExtensionFromSession(), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public void setDestinationAddress(String addr) {
        this.addressToCall = addr.trim();
    }

    public String getDestinationAddress() {
        return this.addressToCall;
    }

    protected String getHoldCallId() {
        VariableName vName = new VariableName(this.holdCallData.toString(), "callid");
        String callId = VariableUtil.getVariableValue((IRuntimeSession)this.getSession(), vName);
        if (callId != null && callId.length() > 0) {
            return callId;
        }
        this.session.throwRTException("No valid call id in CTI Transfer operation for held variable");
        return null;
    }

    public void setUUI(String uui) {
        this.uui = uui.trim().length() > 0 ? uui : "null";
    }

    public String getUUI() {
        return this.uui;
    }

    private void setUUIAsAscii(boolean uuiAsAscii) {
        this.uuiAsAscii = uuiAsAscii;
    }

    private boolean getUUIAsAscii() {
        return this.uuiAsAscii;
    }
}

