/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti.ir;

import com.avaya.sce.runtime.connectivity.cti.CallInfoData;
import com.avaya.sce.runtime.connectivity.cti.VariableUtil;
import com.avaya.sce.runtime.connectivity.cti.ir.CTICommand;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class Dial
extends CTICommand {
    private String _addressToCall;
    private String _uui;
    private String ringMax;
    private boolean uuiAsAscii;
    private VariableName varName = null;
    private Object addressObject = null;
    private VariableName holdCallData = null;
    private Object uuiObject = null;
    private Object ringMaxObject = null;

    public Dial(String name, SCESession session, Object addr, Object heldCallAddress, Object uui, boolean uuiAsAscii, Object ringMax) {
        super(session);
        this.varName = new VariableName(name);
        this.addressObject = addr;
        this.holdCallData = (VariableName)heldCallAddress;
        this.uuiObject = uui;
        this.ringMaxObject = ringMax;
        if (uui != null) {
            this.setUUIAsAscii(uuiAsAscii);
            this.uuiObject = uui;
        }
    }

    public void processResponse(String rawResponse) {
        CallInfoData cid = this.processCallInfoResults(rawResponse);
        if (cid != null) {
            LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)"CallInfo.doGetCallInfo: Populating call info variable values...");
            this.setCallInfoVariableValues(this.varName.toString(), cid);
        }
    }

    public void preExecute() {
        if (this.addressObject instanceof VariableName) {
            this.setDestinationAddress(VariableUtil.getVariableValue((IRuntimeSession)this.session, (VariableName)this.addressObject));
        } else if (this.addressObject instanceof String) {
            this.setDestinationAddress((String)this.addressObject);
        } else {
            throw new IllegalArgumentException("Illegal address type " + this.addressObject.getClass().getName());
        }
        if (this.uuiObject != null) {
            this.setUUIAsAscii(this.uuiAsAscii);
            if (this.uuiObject instanceof VariableName) {
                this.setUUI(VariableUtil.getVariableValue((IRuntimeSession)this.session, (VariableName)this.uuiObject));
            } else if (this.uuiObject instanceof String) {
                this.setUUI((String)this.uuiObject);
            } else {
                throw new IllegalArgumentException("Illegal uui type " + this.uuiObject.getClass().getName());
            }
        }
        if (this.ringMaxObject != null) {
            if (this.ringMaxObject instanceof VariableName) {
                this.setRingMax(VariableUtil.getVariableValue((IRuntimeSession)this.session, (VariableName)this.ringMaxObject));
            } else if (this.ringMaxObject instanceof Integer) {
                this.setRingMax(String.valueOf(this.ringMaxObject));
            } else {
                throw new IllegalArgumentException("Illegal ring max type " + this.ringMax.getClass().getName());
            }
        }
    }

    public String getServletNameParams() {
        String uui = this.getUUI() == null ? "null" : this.getUUI();
        try {
            if (this.isIR()) {
                return "/aesconnector/Dial?" + URLEncoder.encode("callee=" + this.getDestinationAddress() + "&uui=" + uui + "&uuiAsAscii=" + this.getUUIAsAscii() + "&ringMax=" + this.getRingMax() + "&channel=" + this.getExtensionFromSession() + "&holdAddress=" + this.getHoldCallId(), "UTF-8");
            }
            return "/aesconnector/Dial?" + URLEncoder.encode("callee=" + this.getDestinationAddress() + "&uui=" + uui + "&uuiAsAscii=" + this.getUUIAsAscii() + "&ringMax=" + this.getRingMax() + "&extension=" + this.getExtensionFromSession() + "&holdAddress=" + this.getHoldCallId(), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public void setDestinationAddress(String addr) {
        this._addressToCall = addr.trim();
    }

    protected String getHoldCallId() {
        if (this.holdCallData != null) {
            VariableName vName = new VariableName(this.holdCallData.toString(), "callid");
            String callId = VariableUtil.getVariableValue((IRuntimeSession)this.getSession(), vName);
            if (callId != null && callId.length() > 0) {
                return callId;
            }
        }
        return "";
    }

    public String getDestinationAddress() {
        return this._addressToCall;
    }

    public void setUUI(String uui) {
        this._uui = uui.trim().length() > 0 ? uui : "null";
    }

    public String getUUI() {
        return this._uui;
    }

    private void setRingMax(String ringMax) {
        this.ringMax = ringMax;
    }

    private String getRingMax() {
        return this.ringMax;
    }

    private void setUUIAsAscii(boolean uuiAsAscii) {
        this.uuiAsAscii = uuiAsAscii;
    }

    private boolean getUUIAsAscii() {
        return this.uuiAsAscii;
    }
}

