package com.avaya.sce.pdc.pe.launchobcall;

import com.avaya.sce.runtime.IPluggableExecutable;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.ITraceInfo;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.VariableName;
import com.avaya.sce.runtimecommon.SCERT;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.vpwebserviceclient.webservice.VPService;
import com.avaya.sce.vpwebserviceclient.webservice.VPAppIntfServiceStub;
import com.avaya.sce.vpwebserviceclient.webservice.VPAppIntfServiceStub.LaunchCCXML;
import com.avaya.sce.vpwebserviceclient.webservice.VPAppIntfServiceStub.LaunchCCXMLRequest;
import com.avaya.sce.vpwebserviceclient.webservice.VPAppIntfServiceStub.LaunchCCXMLResponseE;

public class LaunchCCXMLCall extends Debugging implements IPluggableExecutable {

	private String resultVar;
	private String resultField;
	private String applicationNameVar;
	private String applicationNameField;
	private boolean applicationNameIsConstant;
	private String applicationURLVar;
	private String applicationURLField;
	private boolean applicationURLIsConstant;
	private String launchTimeoutVar;
	private String launchTimeoutField;
	private boolean launchTimeoutIsConstant;
	private String toURIVar;
	private String toURIField;
	private boolean toURIIsConstant;
	private String parametersVar;
	private String parametersField;
	private boolean parametersIsConstant;
	private String UUIVar;
	private String UUIField;
	private boolean UUIIsConstant;
	private String ZoneVar;
	private String ZoneField;
	private boolean ZoneIsConstant;

	public LaunchCCXMLCall(String resultVar, String resultField, String applicationNameVar, String applicationNameField, boolean applicationNameIsConstant,
			String applicationURLVar, String applicationURLField, boolean applicationURLIsConstant, String launchTimeoutVar,
			String launchTimeoutField, boolean launchTimeoutIsConstant, String toURIVar, String toURIField,
			boolean toURIIsConstant, String parametersVar, String parametersField, boolean parametersIsConstant, String UUIVar,
			String UUIField, boolean UUIIsConstant, String ZoneVar, String ZoneField, boolean ZoneIsConstant) {
		this.resultVar = resultVar;
		this.resultField = resultField;
		this.applicationNameVar = applicationNameVar;
		this.applicationNameField = applicationNameField;
		this.applicationNameIsConstant = applicationNameIsConstant;
		this.launchTimeoutVar = launchTimeoutVar;
		this.launchTimeoutField = launchTimeoutField;
		this.launchTimeoutIsConstant = launchTimeoutIsConstant;
		this.toURIVar = toURIVar;
		this.toURIField = toURIField;
		this.toURIIsConstant = toURIIsConstant;
		this.parametersVar = parametersVar;
		this.parametersField = parametersField;
		this.parametersIsConstant = parametersIsConstant;
		this.applicationURLVar = applicationURLVar;
		this.applicationURLField = applicationURLField;
		this.applicationURLIsConstant = applicationURLIsConstant;
		this.UUIVar = UUIVar;
		this.UUIField = UUIField;
		this.UUIIsConstant = UUIIsConstant;
		this.ZoneVar = ZoneVar;
		this.ZoneField = ZoneField;
		this.ZoneIsConstant = ZoneIsConstant;
	}

	public String getId() {
		return ("com.avaya.sce.pdc.pe.launchobcall");
	}

	public String getTraceMessage() {
		return ("Launching ccxml outbound call to ->" + applicationNameVar + ":" + applicationNameField + " with toURI:" + toURIVar
				+ ":" + toURIField);
	}

	public void execute(IRuntimeSession mySession) {

		IVariableField result = null;
		try {

			String applNameStr, applURLStr = "";
			String paramsStr = "";
			String timeoutStr = "";
			String zoneStr = "";
			String uuiStr = "";
			String touriStr = "";
			int timeoutValue = 0;
			/* set fields to null if it they are empty */
			if ((resultField != null) && (resultField.equals("") == true)) {
				resultField = null;
			}
			
			if ((applicationNameField != null) && (applicationNameField.equals("") == true)) {
				applicationNameField = null;
			}
			if ((toURIField != null) && (toURIField.equals("") == true)) {
				toURIField = null;
			}
			if ((parametersField != null) && (parametersField.equals("") == true)) {
				parametersField = null;
			}
			if ((UUIField != null) && (UUIField.equals("") == true)) {
				UUIField = null;
			}
			if ((applicationURLField != null) && (applicationURLField.equals("") == true)) {
				applicationURLField = null;
			}
			if ((ZoneField != null) && (ZoneField.equals("") == true)) {
				ZoneField = null;
			}
			if ((launchTimeoutField != null) && (launchTimeoutField.equals("") == true)) {
				launchTimeoutField = null;
			}

			result = mySession.getVariableField(new VariableName(resultVar, resultField));
			if (applicationNameIsConstant == true) {
				applNameStr = applicationNameVar;
			} else {
				IVariableField applname = mySession.getVariableField(new VariableName(applicationNameVar, applicationNameField));
				applNameStr = applname.getStringValue();
			}

			if (applicationURLIsConstant == true) {
				applURLStr = applicationURLVar;
			} else {
				if ((applicationURLVar != null) && (applicationURLVar.equals("") != true)) {
					IVariableField appluri = mySession.getVariableField(new VariableName(applicationURLVar, applicationURLField));
					applURLStr = appluri.getStringValue();
				}
			}

			if (toURIIsConstant == true) {
				touriStr = toURIVar;
			} else {
				if ((toURIVar != null) && (toURIVar.equals("") != true)) {
					IVariableField touri = mySession.getVariableField(new VariableName(toURIVar, toURIField));
					touriStr = touri.getStringValue();
				}
			}

			if (parametersIsConstant == true) {
				paramsStr = parametersVar;
			} else {
				if ((parametersVar != null) && (parametersVar.equals("") != true)) {
					IVariableField params = mySession.getVariableField(new VariableName(parametersVar, parametersField));
					paramsStr = params.getStringValue();
				}
			}

			if (UUIIsConstant == true) {
				uuiStr = UUIVar;
			} else {
				if ((UUIVar != null) && (UUIVar.equals("") != true)) {
					IVariableField uui = mySession.getVariableField(new VariableName(UUIVar, UUIField));
					uuiStr = uui.getStringValue();
				}
			}

			boolean hasTimeout = false;
			if (launchTimeoutIsConstant == true) {
				timeoutValue = Integer.parseInt(launchTimeoutVar);
				hasTimeout = true;
			} else {
				if ((launchTimeoutVar != null) && (launchTimeoutVar.equals("") != true)) {
					IVariableField timeout = mySession.getVariableField(new VariableName(launchTimeoutVar, launchTimeoutField));
					timeoutStr = timeout.getStringValue();
					timeoutValue = Integer.parseInt(timeoutStr);
					hasTimeout = true;
				}
			}

			if (ZoneIsConstant) {
				zoneStr = ZoneVar;
			} else {
				if ((ZoneVar != null) && (ZoneVar.equals("") != true)) {
					IVariableField zone = mySession.getVariableField(new VariableName(ZoneVar, ZoneField));
					zoneStr = zone.getStringValue();
				}
			}

			boolean isSimulation = (((SCESession) mySession).getPlatformSettings().getPlatform()
					  .equalsIgnoreCase(SCERT.PLATFORM_DESKTOP)?true:false);
			
			if(isSimulation == true){
				mySession.getTraceOutput().writeln(
					ITraceInfo.TRACE_LEVEL_DEBUG,
					"This is simulation. LaunchCCXML call cannot be done. Here is the parameters:" + " appname:" + applNameStr + " applurl:"
							+ applURLStr + " touri:" + touriStr + " parameters:" + paramsStr + " Launchtimeout:" + timeoutValue
							+ " uui:" + uuiStr + " zone:" + zoneStr);
				return;
			}
			// Start form query for LaunchCCXML
			VPService n = VPService.getInstance();
			VPAppIntfServiceStub service = (VPAppIntfServiceStub) (n.getService((SCESession) mySession));

			if(service == null){
				String err = "cannot get instance of web service stub";
				mySession.getTraceOutput().writeln(
						ITraceInfo.TRACE_LEVEL_ERROR,
						err);
				return;  
			}
			
			/*
			 * fill in ccxml request..
			 */

			LaunchCCXMLRequest ccxmlRequest = new LaunchCCXMLRequest();
			ccxmlRequest.setApplicationName(applNameStr);
			if (touriStr.length() != 0)
				ccxmlRequest.setToURI(touriStr);
			if (uuiStr.length() != 0)
				ccxmlRequest.setUuiInfo(uuiStr);
			if (paramsStr.length() != 0)
				ccxmlRequest.setParameters(paramsStr);
			if (applURLStr.length() != 0)
				ccxmlRequest.setApplicationURL(applURLStr);
			if (zoneStr.length() != 0)
				ccxmlRequest.setZone(zoneStr);

			if (hasTimeout) {
				ccxmlRequest.setLaunchTimeout(timeoutValue);
			}

			LaunchCCXML launchCCXML = new LaunchCCXML();

			mySession.getTraceOutput().writeln(
					ITraceInfo.TRACE_LEVEL_DEBUG,
					"LaunchCCXML call to webservice with following arguments:" + " appname:" + applNameStr + " applurl:"
							+ applURLStr + " touri:" + touriStr + " parameters:" + paramsStr + " Launchtimeout:" + timeoutValue
							+ " uui:" + uuiStr + " zone:" + zoneStr);

			launchCCXML.setArgs0(ccxmlRequest);
			LaunchCCXMLResponseE resp = service.launchCCXML(launchCCXML);
			mySession.getTraceOutput().writeln(ITraceInfo.TRACE_LEVEL_DEBUG, "Launchccxml call returned from webservice call");

			if (resp != null) {
				if ((resp.get_return() != null)) {
					if (resp.get_return().getSessionID_returned().length() == 0) {
						mySession.getTraceOutput().writeln(ITraceInfo.TRACE_LEVEL_DEBUG,
								"Launchccxml call returned an invalid response.");
						if (result != null){
							result.setValue("failed: Launchccxml call returned an invalid response");
						}
					} else {
						mySession.getTraceOutput().writeln(
								ITraceInfo.TRACE_LEVEL_INFO,
								"Launchccxml call returned an valid response. Sessionid="
										+ resp.get_return().getSessionID_returned());
						if (result != null){
							result.setValue("success");
						}
					}
				}
			} else {
				mySession.getTraceOutput().writeln(ITraceInfo.TRACE_LEVEL_ERROR,
						"Launchccxml call returned an invalid response, response is null");
				if (result != null){
					result.setValue("failed: Launchccxml call returned an invalid response, response is null");
				}
			}
		} catch (RuntimeException e) {
	        throw e;
	    }
		catch (Exception e) {
			mySession.getTraceOutput().writeln(ITraceInfo.TRACE_LEVEL_ERROR, 
					"LaunchCCXML error:" + e.getMessage());
			if (result != null){
				result.setValue(e.getMessage());
			}
		}
	}
}
