package com.avaya.sce.pdc.pe.launchobcall;

import com.avaya.sce.runtime.IPluggableExecutable;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.ITraceInfo;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERT;
import com.avaya.sce.runtimecommon.VariableName;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.vpwebserviceclient.webservice.VPService;
import com.avaya.sce.vpwebserviceclient.webservice.VPAppIntfServiceStub;
import com.avaya.sce.vpwebserviceclient.webservice.VPAppIntfServiceStub.LaunchVXML;
import com.avaya.sce.vpwebserviceclient.webservice.VPAppIntfServiceStub.LaunchVXMLRequest;
import com.avaya.sce.vpwebserviceclient.webservice.VPAppIntfServiceStub.LaunchVXMLResponseE;

public class LaunchVXMLCall extends Debugging implements IPluggableExecutable {

	private String resultVar;
	private String resultField;
	private String applicationNameVar;
	private String applicationNameField;
	private boolean applicationNameIsConstant;
	private String applicationURLVar;
	private String applicationURLField;
	private boolean applicationURLIsConstant;
	private String connectTimeoutSecsVar;
	private String connectTimeoutSecsField;
	private boolean connectTimeoutSecsIsConstant;
	private String fromURIVar;
	private String fromURIField;
	private boolean fromURIIsConstant;
	private String toURIVar;
	private String toURIField;
	private boolean toURIIsConstant;
	private String parametersVar;
	private String parametersField;
	private boolean parametersIsConstant;
	private String UUIVar;
	private String UUIField;
	private boolean uuiIsConstant;
	private String ZoneVar;
	private String ZoneField;
	private boolean zoneIsConstant;

	public LaunchVXMLCall(String resultVar, String resultField, String applicationNameVar,
			String applicationNameField, boolean applicationNameIsConstant,
			String applicationURLVar, String applicationURLField,
			boolean applicationURLIsConstant, String connectTimeoutSecsVar,
			String connectTimeoutSecsField,
			boolean connectTimeoutSecsIsConstant, String fromURIVar,
			String fromURIField, boolean fromURIIsConstant, String toURIVar,
			String toURIField, boolean toURIIsConstant, String parametersVar,
			String parametersField, boolean parametersIsConstant,
			String UUIVar, String UUIField, boolean uuiIsConstant,
			String ZoneVar, String ZoneField, boolean zoneIsConstant) {
		this.resultVar = resultVar;
		this.resultField = resultField;
		this.applicationNameVar = applicationNameVar;
		this.applicationNameField = applicationNameField;
		this.applicationNameIsConstant = applicationNameIsConstant;
		this.connectTimeoutSecsVar = connectTimeoutSecsVar;
		this.connectTimeoutSecsField = connectTimeoutSecsField;
		this.connectTimeoutSecsIsConstant = connectTimeoutSecsIsConstant;
		this.fromURIVar = fromURIVar;
		this.fromURIField = fromURIField;
		this.fromURIIsConstant = fromURIIsConstant;
		this.toURIVar = toURIVar;
		this.toURIField = toURIField;
		this.toURIIsConstant = toURIIsConstant;
		this.parametersVar = parametersVar;
		this.parametersField = parametersField;
		this.parametersIsConstant = parametersIsConstant;
		this.applicationURLVar = applicationURLVar;
		this.applicationURLField = applicationURLField;
		this.applicationURLIsConstant = applicationURLIsConstant;
		this.UUIVar = UUIVar;
		this.UUIField = UUIField;
		this.uuiIsConstant = uuiIsConstant;
		this.ZoneVar = ZoneVar;
		this.ZoneField = ZoneField;
		this.zoneIsConstant = zoneIsConstant;
	}

	public String getId() {
		return ("com.avaya.sce.pdc.pe.launchobcall");
	}

	public String getTraceMessage() {
		return ("Launching vxml outbound call to ->" + applicationNameVar + ":"
				+ applicationNameField + " with toURI:" + toURIVar + ":" + toURIField);
	}

	public void execute(IRuntimeSession mySession) {
		
		IVariableField result = null;
		try {

			String applNameStr, applURLStr = "";
			String paramsStr = "";
			String timeoutStr = "";
			String zoneStr = "";
			String uuiStr = "";
			String touriStr = "";
			String fromuriStr = "";
			int timeoutValue = 0;

			/* set fields to null if it they are empty */
			if ((resultField != null) && (resultField.equals("") == true)) {
				resultField = null;
			}
			if ((applicationNameField != null)
					&& (applicationNameField.equals("") == true)) {
				applicationNameField = null;
			}
			if ((fromURIField != null) && (fromURIField.equals("") == true)) {
				fromURIField = null;
			}
			if ((toURIField != null) && (toURIField.equals("") == true)) {
				toURIField = null;
			}
			if ((parametersField != null)
					&& (parametersField.equals("") == true)) {
				parametersField = null;
			}
			if ((UUIField != null) && (UUIField.equals("") == true)) {
				UUIField = null;
			}
			if ((applicationURLField != null)
					&& (applicationURLField.equals("") == true)) {
				applicationURLField = null;
			}
			if ((ZoneField != null) && (ZoneField.equals("") == true)) {
				ZoneField = null;
			}
			if ((connectTimeoutSecsField != null)
					&& (connectTimeoutSecsField.equals("") == true)) {
				connectTimeoutSecsField = null;
			}

			result = mySession.getVariableField(new VariableName(resultVar, resultField));
			if (!applicationNameIsConstant) {
				IVariableField applname = mySession
						.getVariableField(new VariableName(applicationNameVar,
								applicationNameField));
				applNameStr = applname.getStringValue();
			} else
				applNameStr = applicationNameVar;

			if (!toURIIsConstant) {
				IVariableField touri = mySession
						.getVariableField(new VariableName(toURIVar, toURIField));
				touriStr = touri.getStringValue();
			} else
				touriStr = toURIVar;

			if (!applicationURLIsConstant) {
				if ((applicationURLVar != null)
						&& (applicationURLVar.equals("") != true)) {
					IVariableField applurl = mySession
							.getVariableField(new VariableName(
									applicationURLVar, applicationURLField));
					applURLStr = applurl.getStringValue();
				}
			} else
				applURLStr = applicationURLVar;

			if (parametersIsConstant) {
				paramsStr = parametersVar;
			} else {
				if ((parametersVar != null)
						&& (parametersVar.equals("") != true)) {
					IVariableField params = mySession
							.getVariableField(new VariableName(parametersVar,
									parametersField));
					paramsStr = params.getStringValue();
				}
			}

			if (uuiIsConstant) {
				uuiStr = UUIVar;
			} else {
				if ((UUIVar != null) && (UUIVar.equals("") != true)) {
					IVariableField uui = mySession
							.getVariableField(new VariableName(UUIVar, UUIField));
					uuiStr = uui.getStringValue();
				}
			}

			boolean hasTimeout = false;
			if (connectTimeoutSecsIsConstant == true) {
				timeoutValue = Integer.parseInt(connectTimeoutSecsVar);
				hasTimeout = true;
			} else {
				if ((connectTimeoutSecsVar != null)
						&& (connectTimeoutSecsVar.equals("") != true)) {
					IVariableField timeout = mySession
							.getVariableField(new VariableName(
									connectTimeoutSecsVar,
									connectTimeoutSecsField));
					timeoutStr = timeout.getStringValue();
					timeoutValue = Integer.parseInt(timeoutStr);
					hasTimeout = true;
				}
			}

			if (zoneIsConstant) {
				zoneStr = ZoneVar;
			} else {
				if ((ZoneVar != null) && (ZoneVar.equals("") != true)) {
					IVariableField zone = mySession
							.getVariableField(new VariableName(ZoneVar,
									ZoneField));
					zoneStr = zone.getStringValue();
				}
			}

			if (fromURIIsConstant) {
				fromuriStr = fromURIVar;
			} else {
				if ((fromURIVar != null) && (fromURIVar.equals("") != true)) {
					IVariableField fromuri = mySession
							.getVariableField(new VariableName(fromURIVar,
									fromURIField));
					fromuriStr = fromuri.getStringValue();
				}
			}

			boolean isSimulation = (((SCESession) mySession).getPlatformSettings().getPlatform()
					  .equalsIgnoreCase(SCERT.PLATFORM_DESKTOP)?true:false);
			
			if(isSimulation == true){
				mySession.getTraceOutput().writeln(
					ITraceInfo.TRACE_LEVEL_DEBUG,
					"This is simulation. LaunchCCXML call cannot be done. Here is the parameters:" + " appname:" + applNameStr + " applurl:"
							+ applURLStr + " touri:" + touriStr + " parameters:" + paramsStr + " Launchtimeout:" + timeoutValue
							+ " uui:" + uuiStr + " zone:" + zoneStr);
				return;
			}
			// Start form query for LaunchVXML
			VPService n = VPService.getInstance();
			VPAppIntfServiceStub service = (VPAppIntfServiceStub) (n
					.getService((SCESession) mySession));

			if(service == null){
				String err = "cannot get instance of web service stub";
				mySession.getTraceOutput().writeln(
						ITraceInfo.TRACE_LEVEL_ERROR,
						err);
				return;  
			}
			
			/*
			 * fill in vxml request..
			 */

			LaunchVXMLRequest vxmlRequest = new LaunchVXMLRequest();
			vxmlRequest.setApplicationName(applNameStr);
			vxmlRequest.setToURI(touriStr);
			if (fromuriStr.length() != 0)
				vxmlRequest.setFromURI(fromuriStr);
			if (uuiStr.length() != 0)
				vxmlRequest.setUuiInfo(uuiStr);
			if (paramsStr.length() != 0)
				vxmlRequest.setParameters(paramsStr);
			if (applURLStr.length() != 0)
				vxmlRequest.setApplicationURL(applURLStr);
			if (zoneStr.length() != 0)
				vxmlRequest.setZone(zoneStr);
			if (hasTimeout) {
				vxmlRequest.setConnectTimeoutSecs(timeoutValue);
			}

			LaunchVXML launchVXML = new LaunchVXML();

			mySession.getTraceOutput().writeln(
					ITraceInfo.TRACE_LEVEL_DEBUG,
					"LaunchVXML call to webservice with following arguments:"
							+ " appname:" + applNameStr + " applurl:"
							+ applURLStr + " touri:" + touriStr
							+ " parameters:" + paramsStr + " uui:" + uuiStr
							+ " zone:" + zoneStr);

			launchVXML.setArgs0(vxmlRequest);
			LaunchVXMLResponseE resp = service.launchVXML(launchVXML);
			mySession.getTraceOutput().writeln(ITraceInfo.TRACE_LEVEL_DEBUG,
					"Launchvxml call returned from webservice call");

			if (resp != null) {
				if ((resp.get_return() != null)) {
					if (resp.get_return().getSessionID_returned().length() == 0) {
						mySession.getTraceOutput().writeln(
								ITraceInfo.TRACE_LEVEL_DEBUG,
								"Launchvxml call returned an invalid response.");
						if (result != null){
							result.setValue("failed: Launchvxml call returned an invalid response");
						}
					} else {
						mySession.getTraceOutput().writeln(
								ITraceInfo.TRACE_LEVEL_INFO,
								"Launchvxml call returned an valid response. Sessionid="
										+ resp.get_return()
												.getSessionID_returned());
						if (result != null){
							result.setValue("success");
						}
					}
				}
			} else {
				mySession
						.getTraceOutput()
						.writeln(ITraceInfo.TRACE_LEVEL_ERROR,
								"Launchvxml call returned an invalid response, response is null");
				if (result != null){
					result.setValue("failed: Launchvxml call returned an invalid response, response is null");
				}
			}
		} catch (RuntimeException e) {
	        throw e;
	    } 
		catch (Exception e) {
			mySession.getTraceOutput().writeln(ITraceInfo.TRACE_LEVEL_ERROR, 
					"LaunchVXML error:" + e.getMessage());
			if (result != null){
				result.setValue(e.getMessage());
			}
		}
	}

}
