/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti;

import java.util.ArrayList;
import java.util.List;

public class CallInfoData {
    public static final String FIELD_DELIMITER = ":";
    public static final String CALLINFO_DELIMITER = ";";
    public static final String UNKNOWN_UCID = "00000000000000000000";
    public static final String UNKNOWN_STATE = "UNKNOWN";
    private final String _callId;
    private final String _calledNumber;
    private final String _callingNumber;
    private final String _extension;
    private final String _ucId;
    private final String _uui;
    private String _state = "UNKNOWN";

    public CallInfoData(String callId, String callingNumber, String calledNumber, String extension, String ucId, String uui) {
        this(callId, callingNumber, calledNumber, extension, ucId, uui, UNKNOWN_STATE);
    }

    public CallInfoData(String callId, String callingNumber, String calledNumber, String extension, String ucId, String uui, String state) {
        this._callId = callId;
        this._callingNumber = callingNumber;
        this._calledNumber = calledNumber;
        this._extension = extension;
        this._ucId = ucId;
        this._uui = uui;
        this._state = state;
    }

    public static List parseCallInfo(String data) {
        String[] info = data.split(CALLINFO_DELIMITER);
        int numCalls = info.length;
        ArrayList<CallInfoData> callInfo = new ArrayList<CallInfoData>(numCalls);
        for (int i = 0; i < numCalls; ++i) {
            String[] tokens = info[i].split(FIELD_DELIMITER);
            if (tokens.length != 7) continue;
            callInfo.add(new CallInfoData(tokens[0], tokens[1], tokens[2], tokens[3], tokens[4], tokens[5]));
        }
        return callInfo;
    }

    public String getCallId() {
        return this._callId;
    }

    public String getExtension() {
        return this._extension;
    }

    public String getCalledNumber() {
        return this._calledNumber;
    }

    public String getCallingNumber() {
        return this._callingNumber;
    }

    public String getUCID() {
        return this._ucId;
    }

    public String getUUI() {
        return this._uui;
    }

    public String getState() {
        return this._state;
    }

    public void setState(String state) {
        this._state = state;
    }

    public String toString() {
        return this._callId + FIELD_DELIMITER + this._callingNumber + FIELD_DELIMITER + this._calledNumber + FIELD_DELIMITER + this._extension + FIELD_DELIMITER + this._ucId + FIELD_DELIMITER + this._uui + FIELD_DELIMITER + this._state;
    }
}

