/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.ExternalPhrase;
import com.avaya.sce.runtime.Phrase;
import com.avaya.sce.runtime.Phraseset;
import com.avaya.sce.runtime.PromptElement;
import com.avaya.sce.runtime.internal.PhraseFinder;
import com.avaya.sce.runtime.internal.PhrasesetFinder;
import com.avaya.sce.runtimecommon.ICollection;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.VariableName;
import java.util.StringTokenizer;

public class PhraseVariableElement
extends PromptElement {
    private Type varType;
    private String backupText;
    private String backupVar;

    public PhraseVariableElement(String variableName, Type varType) {
        this(variableName, varType, null, null, false);
    }

    public PhraseVariableElement(String variableName, Type varType, boolean asMedia) {
        this(variableName, varType, null, null, asMedia);
    }

    public PhraseVariableElement(String variableName, Type varType, String backupText, String backupVar) {
        super(10, variableName);
        this.varType = varType;
        this.backupText = backupText;
        this.backupVar = backupVar;
    }

    public PhraseVariableElement(String variableName, Type varType, String backupText, String backupVar, boolean asMedia) {
        super(10, variableName, asMedia);
        this.varType = varType;
        this.backupText = backupText;
        this.backupVar = backupVar;
    }

    public String getBackupText() {
        return this.backupText;
    }

    public void setBackupText(String backupText) {
        this.backupText = backupText;
    }

    public String getBackupVar() {
        return this.backupVar;
    }

    public void setBackupVar(String backupVar) {
        this.backupVar = backupVar;
    }

    public Type getVarType() {
        return this.varType;
    }

    public void setVarType(Type varType) {
        this.varType = varType;
    }

    public Phrase getPhrase() {
        IVariableField field = this.mySession.getVariableField(new VariableName(this.getValue()));
        if (field == null) {
            throw new SCERuntimeException("Unable to get session variable: " + this.getValue());
        }
        Boolean isPrivate = (Boolean)field.getAttribute("avaya.dd.private");
        if (isPrivate.booleanValue()) {
            this.mySession.setProperty("___sagenovxmltrace", (Object)new Boolean(true));
        }
        String phraseName = field.getStringValue();
        Phrase phrase = null;
        if (this.getLanguage() == null) {
            this.setLanguage(this.mySession.getCurrentLanguage());
        }
        switch (this.getVarType()) {
            case PHRASESET_PHRASE: {
                StringTokenizer st = new StringTokenizer(phraseName, ":");
                if (st.countTokens() != 2) {
                    throw new SCERuntimeException("Illegal phraseset phrase identifier: " + phraseName);
                }
                Phraseset phraseset = PhrasesetFinder.load(st.nextToken(), this.getLanguage());
                if (phraseset == null) {
                    throw new SCERuntimeException("Unable to load phraseset: " + phraseName);
                }
                phraseset.setMySession(this.mySession);
                phrase = phraseset.getPhrase(st.nextToken());
                break;
            }
            case PHRASE: {
                phrase = PhraseFinder.load(phraseName, this.getLanguage());
                break;
            }
            case AUDIO_URL: {
                phrase = new ExternalPhrase(phraseName);
                phrase.setType(Phrase.Type.PHRASESET_PHRASE);
                break;
            }
            default: {
                throw new SCERuntimeException("Illegal variable type for PhraseVariable: " + (Object)((Object)this.getVarType()));
            }
        }
        if (phrase == null) {
            throw new SCERuntimeException("Unable to load phrase: " + phraseName);
        }
        phrase.mySession = this.mySession;
        if (this.getBackupText() != null && this.getBackupText().length() != 0) {
            phrase.setText(this.getBackupText());
        } else if (this.getBackupVar() != null && this.getBackupVar().length() != 0 && (field = this.mySession.getVariableField(new VariableName(this.getBackupVar()))) != null) {
            phrase.setText(field.getStringValue());
        }
        return phrase;
    }

    public Phrase[] getPhrases() {
        Phrase[] phrases;
        IVariable variable = this.mySession.getVariable(new VariableName(this.getValue()).getVarName());
        if (variable == null) {
            throw new SCERuntimeException("Unable to get session variable: " + this.getValue());
        }
        if (variable.isCollection()) {
            IVariable bkup;
            ICollection phraseCollection = variable.getCollection();
            ICollection bkupCollection = null;
            int size = phraseCollection.size();
            if (!(this.getBackupVar() == null || (bkup = this.mySession.getVariable(new VariableName(this.getBackupVar()).getVarName())).isCollection() && (bkupCollection = bkup.getCollection()).size() == size)) {
                throw new SCERuntimeException("Incompatible collection variables are used for the Phrase Variable and the backup text variable. The variables must both be collections with the same size in order to use with a collection.");
            }
            phrases = new Phrase[size];
            boolean collectionsDifferent = phraseCollection != bkupCollection;
            int i = 0;
            phraseCollection.reset();
            if (bkupCollection != null && collectionsDifferent) {
                bkupCollection.reset();
            }
            while (phraseCollection.hasMore()) {
                phraseCollection.next();
                if (bkupCollection != null && collectionsDifferent) {
                    bkupCollection.next();
                }
                phrases[i++] = this.getPhrase();
            }
        } else {
            phrases = new Phrase[]{this.getPhrase()};
        }
        return phrases;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PHRASESET_PHRASE,
        PHRASE,
        AUDIO_URL,
        DTMF_TONES;

    }
}

