/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.tracking;

import com.avaya.sce.runtime.internal.Utils;
import com.avaya.sce.runtime.tracking.Trackable;
import com.avaya.sce.runtimecommon.ITraceInfo;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;

public class TraceInfo
extends Trackable {
    private String text;
    private int level;
    private VariableName variableName;

    public TraceInfo(int level, String text, String varaibleName) {
        this.level = level;
        this.text = text;
        this.variableName = varaibleName.length() > 0 ? new VariableName(varaibleName) : null;
    }

    public void trackItems(SCESession mySession) {
        ITraceInfo writer = mySession.getTraceOutput();
        if (writer != null && mySession.isAppTraceEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(Utils.getID(mySession, true) + " | ");
            String appName = mySession.getAppName();
            if (appName.startsWith("/")) {
                appName = appName.substring(1);
            }
            sb.append(appName + ":" + mySession.getServlet().getServletName() + " | ");
            if (this.text != null) {
                sb.append(this.text);
            }
            if (this.variableName != null) {
                sb.append(" | ");
                sb.append(this.variableName);
                sb.append(" : ");
                this.formatVariable(mySession, this.variableName, sb);
            }
            writer.writeln(this.level, sb.toString());
        }
    }

    public static void trace(int level, String reason, Exception e, SCESession mySession) {
        ITraceInfo writer = mySession.getTraceOutput();
        StringBuffer sb = new StringBuffer();
        if (writer == null || !mySession.isAppTraceEnabled()) {
            return;
        }
        sb.append(Utils.getID(mySession, true) + " | ");
        sb.append(reason);
        sb.append("\r\n");
        Trackable.formatException(e, sb);
        writer.writeln(level, sb.toString());
    }

    public static void trace(int level, Exception e, SCESession mySession) {
        ITraceInfo writer = mySession.getTraceOutput();
        if (writer == null || !mySession.isAppTraceEnabled()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Utils.getID(mySession, true) + " | ");
        Trackable.formatException(e, sb);
        writer.writeln(level, sb.toString());
    }

    public static void trace(int level, String reason, SCESession mySession) {
        ITraceInfo writer = mySession.getTraceOutput();
        if (writer == null || !mySession.isAppTraceEnabled()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Utils.getID(mySession, true) + " | ");
        sb.append(reason);
        writer.writeln(level, sb.toString());
    }
}

