/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti.desktop;

import com.avaya.sce.runtime.connectivity.cti.CallInfoData;
import com.avaya.sce.runtime.connectivity.cti.ICTICallOperation;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IExecutable;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.sce.runtimecommon.SCESession;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

public abstract class CTICallOperation
extends Debugging
implements ICTICallOperation,
IExecutable {
    public static final int CTI_SIMULATOR_PORT = 5555;
    public static final String DIAL_ERROR_RESP = "Dial error";
    public static final String HOLD_ERROR_RESP = "Hold error";
    public static final String RETRIEVE_ERROR_RESP = "Retrieve error";
    public static final String DISCONNECT_ERROR_RESP = "Disconnect error";
    public static final String TRANSFER_ERROR_RESP = "Transfer error";
    public static final String CONFERENCE_ERROR_RESP = "Conference error";
    public static final String CALLINFO_ERROR_RESP = "Callinfo error";
    public static final String UNKNOWN_REQ_RESP = "Unknown request";
    private static Map<String, String> callIdToStateMap = new HashMap<String, String>();
    protected Socket socket;
    protected PrintWriter out;
    protected BufferedReader in;
    private SCESession session;
    private String name;

    protected abstract void handleResponse(String var1);

    public CTICallOperation() {
    }

    public CTICallOperation(SCESession session) {
        this.session = session;
        this.initComm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            this.doOperation();
        }
        finally {
            try {
                this.closeComm();
            }
            catch (Exception e) {
                this.session.throwRTException("Unable to close socket connections: " + e.getMessage(), e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized CallInfoData getCurrentCallInfo() {
        CallInfoData info = null;
        try {
            info = (CallInfoData)this.session.getProperty("___CTI.CallInfo");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (info == null) {
            info = new CallInfoData("0", "", "", "", "", "", "established");
            this.session.setProperty("___CTI.CallInfo", (Object)info);
        }
        return info;
    }

    protected SCESession getSession() {
        return this.session;
    }

    protected void sendMessage(String msg) {
        this.out.println(msg);
        this.out.flush();
        LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICallOperation Request: " + msg));
    }

    protected String receiveMessage() {
        String response = "";
        try {
            response = this.in.readLine();
            if (response != null) {
                this.handleResponse(response);
            }
            LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)("CTICallOperation Response: " + response));
        }
        catch (IOException e) {
            this.session.throwRTException("Error reading socket", (Exception)e);
        }
        return response;
    }

    protected static synchronized void updateCallState(String id, String state) {
        callIdToStateMap.put(id, state);
    }

    protected static synchronized String getCallState(String id) {
        return callIdToStateMap.get(id);
    }

    protected void setCallState(String varName, String state) {
        IComplexVariable infoVar = (IComplexVariable)this.getSession().getVariable(varName);
        infoVar.getField("state").setValue(state);
    }

    protected void setCallInfoVariableValues(String varName, CallInfoData info) {
        if (info == null) {
            return;
        }
        IComplexVariable infoVar = (IComplexVariable)this.getSession().getVariable(varName);
        infoVar.getField("callid").setValue(info.getCallId());
        infoVar.getField("ani").setValue(info.getCallingNumber());
        infoVar.getField("dnis").setValue(info.getCalledNumber());
        infoVar.getField("stationextension").setValue(info.getExtension());
        infoVar.getField("ucid").setValue(info.getUCID());
        infoVar.getField("uui").setValue(info.getUUI());
        infoVar.getField("state").setValue(info.getState());
    }

    private void initComm() {
        try {
            this.socket = new Socket("localhost", 5555);
            this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream())), true);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (IOException e) {
            this.session.throwRTException("Unable to get socket connection: " + e + ": " + e.getMessage(), (Exception)e);
        }
    }

    private void closeComm() {
        try {
            if (this.out != null) {
                this.out.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception e) {
            this.session.throwRTException("Problems closing connection: " + e.getMessage(), e);
        }
    }
}

