/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti.ir;

import com.avaya.sce.runtime.connectivity.cti.CallInfoData;
import com.avaya.sce.runtime.connectivity.cti.VariableUtil;
import com.avaya.sce.runtime.connectivity.cti.ir.CTICommand;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class ConferenceParty
extends CTICommand {
    private String partyNumber;
    private VariableName callData = null;
    private Object partyNumberObject = null;

    public ConferenceParty(SCESession session, Object callData, Object partyNumber) {
        super(session);
        if (callData == null) {
            return;
        }
        if (!(callData instanceof VariableName)) {
            throw new IllegalArgumentException("Illegal calldata type " + callData.getClass().getName());
        }
        this.callData = (VariableName)callData;
        this.partyNumberObject = partyNumber;
    }

    public String getServletNameParams() {
        try {
            if (this.isIR()) {
                return "/aesconnector/ConferenceParty?" + URLEncoder.encode("callid=" + this.getConferenceCallId() + "&partyNumber=" + this.getPartyNumber(), "UTF-8") + URLEncoder.encode("&channel=" + this.getExtensionFromSession(), "UTF-8");
            }
            return "/aesconnector/ConferenceParty?" + URLEncoder.encode("callid=" + this.getConferenceCallId() + "&partyNumber=" + this.getPartyNumber(), "UTF-8") + URLEncoder.encode("&extension=" + this.getExtensionFromSession(), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public void preExecute() {
        if (this.partyNumberObject instanceof VariableName) {
            String number = VariableUtil.getVariableValue((IRuntimeSession)this.session, (VariableName)this.partyNumberObject);
            this.setPartyNumber(number.trim());
        } else if (this.partyNumberObject instanceof String) {
            this.setPartyNumber(((String)this.partyNumberObject).trim());
        } else {
            throw new IllegalArgumentException("Illegal partynumber type " + this.partyNumberObject.getClass().getName());
        }
    }

    public void processResponse(String rawResponse) {
        CallInfoData callInfoData = this.processCallInfoResults(rawResponse);
        if (callInfoData != null) {
            this.updateCallInfoVariableState(this.callData, callInfoData.getState());
        }
    }

    public String getConferenceCallId() {
        VariableName vName = new VariableName(this.callData.toString(), "callid");
        String callId = VariableUtil.getVariableValue((IRuntimeSession)this.getSession(), vName);
        if (callId != null && callId.length() > 0) {
            return callId;
        }
        this.session.throwRTException("No valid call id in CTI conference party operation for calldata variable");
        return null;
    }

    public String getPartyNumber() {
        return this.partyNumber;
    }

    public void setPartyNumber(String partyNumber) {
        this.partyNumber = partyNumber;
    }
}

