/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.runtime.platforms.Toolkit;
import com.avaya.sce.runtime.FillerRule;
import com.avaya.sce.runtime.GrammarRule;
import com.avaya.sce.runtime.IGrammarRule;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.IRuntimeGrammar;
import com.avaya.sce.runtime.ReferenceRule;
import com.avaya.sce.runtimecommon.PlatformSettings;
import com.avaya.sce.runtimecommon.SCERT;
import com.avaya.sce.runtimecommon.SCESession;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DynamicGrammar
implements IRuntimeGrammar {
    String language;
    ArrayList<IGrammarRule> rules = new ArrayList();
    String compatibility = "SRGS-Literals";
    String mode = "voice";
    String weight = "1.0";
    protected SCESession mySession;
    boolean enabled = true;
    private ArrayList<String> colIds = new ArrayList();
    private String rootName = this.getClass().getName();

    public DynamicGrammar() {
        int index = this.rootName.lastIndexOf(46);
        if (index != -1) {
            this.rootName = this.rootName.substring(index + 1);
        }
    }

    public final void setCompatibility(String value) {
        this.compatibility = (String)SCERT.ASR_TYPES_MAP.get(value);
        for (int i = 0; i < this.rules.size(); ++i) {
            IGrammarRule rule = this.rules.get(i);
            rule.setCompatibility(this.compatibility);
        }
    }

    public final void setcColIds() {
        for (int i = 0; i < this.rules.size(); ++i) {
            IGrammarRule rule = this.rules.get(i);
            if (rule.getId() != null) continue;
            if (i < this.colIds.size()) {
                String id = this.colIds.get(i);
                rule.setId(id);
                continue;
            }
            rule.setId("Column" + i);
        }
    }

    public void addColName(String value) {
        this.colIds.add(value);
    }

    @Override
    public String getCompatibility() {
        return this.compatibility;
    }

    public final void setMode(String value) {
        this.mode = value;
        for (int i = 0; i < this.rules.size(); ++i) {
            IGrammarRule rule = this.rules.get(i);
            rule.setMode(value);
        }
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public final void generate(IOutputGenerator generator) {
        if (this.mySession == null) {
            this.mySession = generator.getMySession();
        }
        if (this.language == null) {
            this.language = Toolkit.getCurrentLanguageASR(generator.getMySession());
        }
        generator.dynamicGrammarBegin(this);
        generator.dynamicGrammarEnd(this);
    }

    public void add(IGrammarRule rule) {
        rule.setCompatibility(this.compatibility);
        rule.setMode(this.mode);
        this.rules.add(rule);
    }

    @Override
    public List<String> getColumnIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (IGrammarRule rule : this.rules) {
            if (!(rule instanceof GrammarRule)) continue;
            result.add(rule.getId());
        }
        return result;
    }

    private void genRuleTag(boolean first, StringBuffer grammar, StringBuffer slotTags, String slotName, String ruleName) {
        if (this.compatibility.equals("Nuance OSR")) {
            if (first) {
                grammar.append(ruleName + ".atag");
            } else {
                grammar.append(" + ' ' + " + ruleName + ".atag");
            }
            slotTags.append(slotName + "=" + ruleName + ".atag;");
        } else if (this.compatibility.equals("IBM")) {
            if (first) {
                grammar.append("$" + ruleName);
            } else {
                grammar.append(" + ' ' + $" + ruleName);
            }
            slotTags.append("$." + slotName + "=$" + ruleName + ";");
        } else if (this.compatibility.equals("SRGS-SISR")) {
            if (first) {
                grammar.append("rules." + ruleName);
            } else {
                grammar.append(" + ' ' + rules." + ruleName);
            }
            slotTags.append("out." + slotName + "=rules." + ruleName + ";");
        }
    }

    public String convertToString(boolean isExternalGram) {
        int i;
        StringBuffer grammar = new StringBuffer();
        StringBuffer slotTags = new StringBuffer();
        if (isExternalGram) {
            if (this.compatibility.equals("SRGS-Literals")) {
                grammar.append("<grammar xmlns=\"http://www.w3.org/2001/06/grammar\" mode=\"" + this.mode + "\" root=\"" + this.rootName + "\" version=\"1.0\" xml:lang=\"" + this.language + "\" tag-format=\"semantics/1.0-literals\">");
            } else if (this.compatibility.equals("Nuance OSR")) {
                grammar.append("<grammar xmlns=\"http://www.w3.org/2001/06/grammar\" mode=\"" + this.mode + "\" root=\"" + this.rootName + "\" version=\"1.0\" xml:lang=\"" + this.language + "\">");
            } else {
                grammar.append("<grammar xmlns=\"http://www.w3.org/2001/06/grammar\" mode=\"" + this.mode + "\" root=\"" + this.rootName + "\" version=\"1.0\" xml:lang=\"" + this.language + "\" tag-format=\"semantics/1.0\">");
            }
        } else if (this.mySession != null && this.mySession.getMessageType() != SCESession.MessageType.speech) {
            grammar.append("<grammar mode=\"" + this.mode + "\" root=\"" + this.rootName + "\" version=\"1.0\" xml:lang=\"" + this.language + "\" tag-format=\"semantics/1.0-literals\">");
        } else if (this.compatibility.equals("SRGS-Literals")) {
            grammar.append("<grammar type=\"application/srgs+xml\" mode=\"" + this.mode + "\" root=\"" + this.rootName + "\" weight=\"" + this.weight + "\" xml:lang=\"" + this.language + "\" version=\"1.0\" tag-format=\"semantics/1.0-literals\">");
        } else if (this.compatibility.equals("Nuance OSR")) {
            grammar.append("<grammar type=\"application/srgs+xml\"  mode=\"" + this.mode + "\" root=\"" + this.rootName + "\" weight=\"" + this.weight + "\" xml:lang=\"" + this.language + "\">");
        } else {
            grammar.append("<grammar type=\"application/srgs+xml\" mode=\"" + this.mode + "\" root=\"" + this.rootName + "\" weight=\"" + this.weight + "\" xml:lang=\"" + this.language + "\" version=\"1.0\" tag-format=\"semantics/1.0\">");
        }
        grammar.append("<rule id=\"" + this.rootName + "\" scope=\"public\">");
        for (i = 0; i < this.rules.size(); ++i) {
            IGrammarRule rule = this.rules.get(i);
            if (rule instanceof GrammarRule) {
                grammar.append("<ruleref uri=\"#" + rule.getId() + "\" />");
                continue;
            }
            if (rule instanceof FillerRule) {
                grammar.append(rule.toString(i));
                continue;
            }
            if (!(rule instanceof ReferenceRule)) continue;
            grammar.append(rule.toString(i));
        }
        if (!this.compatibility.equals("SRGS-Literals")) {
            grammar.append("<tag>");
            if (this.compatibility.equals("Nuance OSR")) {
                grammar.append("cxtag=");
            } else if (this.compatibility.equals("IBM")) {
                grammar.append("$.cxtag=");
            } else if (this.compatibility.equals("SRGS-SISR")) {
                grammar.append("out.cxtag=");
            }
            boolean first = true;
            for (int i2 = 0; i2 < this.rules.size(); ++i2) {
                IGrammarRule rule = this.rules.get(i2);
                if (rule instanceof GrammarRule) {
                    this.genRuleTag(first, grammar, slotTags, rule.getId(), rule.getId());
                }
                if (rule instanceof ReferenceRule) {
                    ReferenceRule ref = (ReferenceRule)rule;
                    this.genRuleTag(first, grammar, slotTags, ref.getSlotName(), ref.getId());
                }
                if (!first) continue;
                first = false;
            }
            if (this.compatibility.equals("IBM")) {
                grammar.append(";");
                grammar.append(slotTags);
            } else if (this.compatibility.equals("Nuance OSR")) {
                grammar.append(";");
                grammar.append(slotTags);
            } else if (this.compatibility.equals("SRGS-SISR")) {
                grammar.append(";");
                grammar.append(slotTags);
            }
            grammar.append("</tag>");
        }
        grammar.append("</rule>");
        for (i = 0; i < this.rules.size(); ++i) {
            IGrammarRule rule = this.rules.get(i);
            if (!(rule instanceof GrammarRule)) continue;
            grammar.append(rule.toString(i));
        }
        grammar.append("</grammar>");
        return grammar.toString();
    }

    public String toString() {
        if (this.language == null) {
            this.setLanguage(Toolkit.getCurrentLanguageASR(this.mySession));
        }
        String compatibility = this.mySession.getPlatformSettings().getASR();
        if (this.mode.equals("dtmf")) {
            PlatformSettings.DTMFMode dtmfMode = this.mySession.getPlatformSettings().getDTMFNative();
            if (dtmfMode == PlatformSettings.DTMFMode.LOCAL_SRGS_LITERALS) {
                compatibility = "SRGS-Literals";
            } else if (dtmfMode == PlatformSettings.DTMFMode.LOCAL_SRGS_SISR) {
                compatibility = "SRGS-SISR";
            }
        }
        this.setCompatibility(compatibility);
        return this.convertToString(false);
    }

    public String toString(String language, String compatibility, String mode) {
        this.setLanguage(language);
        this.setCompatibility(compatibility);
        this.setMode(mode);
        return this.convertToString(true);
    }

    public String toString(String language, String compatibility, String mode, String name) {
        this.setLanguage(language);
        this.setCompatibility(compatibility);
        this.setMode(mode);
        this.rootName = name;
        return this.convertToString(true);
    }

    public abstract void buildGrammar(SCESession var1);

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(String weight) {
        this.weight = weight;
    }

    @Override
    public void setSession(SCESession session) {
        this.mySession = session;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void updateGrammar(SCESession mySession) {
    }
}

